/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.sfp;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sessions {
    private static final Logger logger = LoggerFactory.getLogger(Sessions.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String ATTR_CHARSET = "charset";
    public static final String ATTR_LITTLE_ENDIAN = "littleEndian";

    public static CharsetEncoder getCharsetEncoder(IoSession session) {
        Object charset = session.getAttribute((Object)ATTR_CHARSET, (Object)Charset.forName(DEFAULT_CHARSET_NAME));
        if (charset instanceof Charset) {
            return ((Charset)charset).newEncoder();
        }
        return Charset.forName(DEFAULT_CHARSET_NAME).newEncoder();
    }

    public static CharsetDecoder getCharsetDecoder(IoSession session) {
        Object charset = session.getAttribute((Object)ATTR_CHARSET, (Object)Charset.forName(DEFAULT_CHARSET_NAME));
        if (charset instanceof Charset) {
            return ((Charset)charset).newDecoder();
        }
        return Charset.forName(DEFAULT_CHARSET_NAME).newDecoder();
    }

    public static void setCharset(IoSession session, Charset charset) {
        logger.info("Setting character encoding to {} - session: {}", (Object)(charset != null ? charset.name() : null), (Object)session);
        session.setAttribute((Object)ATTR_CHARSET, (Object)charset);
    }

    public static void setLittleEndian(IoSession session) {
        logger.info("Setting byte order to little endian - session: {}", (Object)session);
        session.setAttribute((Object)ATTR_LITTLE_ENDIAN);
    }

    public static boolean isLittleEndian(IoSession session) {
        return session.containsAttribute((Object)ATTR_LITTLE_ENDIAN);
    }
}

