/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.sfp.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scada.core.Variant;

public class DataUpdate {
    private final Collection<Entry> entries;

    public DataUpdate(Collection<Entry> entries) {
        this.entries = Collections.unmodifiableList(new ArrayList<Entry>(entries));
    }

    public Collection<Entry> getEntries() {
        return this.entries;
    }

    public static class Entry {
        private final int register;
        private final Variant value;
        private final long timestamp;
        private final Set<State> states;
        private final byte missedUpdates;

        public Entry(int register, Variant value, long timestamp, Set<State> states, byte missedUpdates) {
            this.register = register;
            this.value = value;
            this.timestamp = timestamp;
            this.states = Collections.unmodifiableSet(new HashSet<State>(states));
            this.missedUpdates = missedUpdates;
        }

        public int getRegister() {
            return this.register;
        }

        public Set<State> getStates() {
            return this.states;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Variant getValue() {
            return this.value;
        }

        public byte getMissedUpdates() {
            return this.missedUpdates;
        }
    }

    public static enum State {
        ERROR,
        ALARM,
        WARNING,
        ERROR_ACK,
        ALARM_ACK,
        WARNING_ACK,
        MANUAL_OVERRIDE,
        BLOCKED;

    }
}

