/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.handler.script;

import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.handler.AbstractEventHandler;
import org.eclipse.scada.ae.server.handler.InjectionContext;
import org.eclipse.scada.ae.server.injector.EventInjectorQueue;
import org.eclipse.scada.utils.script.ScriptExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEventHandler
extends AbstractEventHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)(String.valueOf(ScriptEventHandler.class.getName()) + ".scripts"));
    private final ScriptExecutor script;
    private final EventInjectorQueue injector;

    public ScriptEventHandler(ScriptExecutor script, EventInjectorQueue injector) {
        this.script = script;
        this.injector = injector;
    }

    public Event handleEvent(Event event, InjectionContext context) {
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        try {
            scriptContext.setAttribute("event", event, 200);
            scriptContext.setAttribute("logger", logger, 200);
            scriptContext.setAttribute("injector", this.injector, 200);
            Object result = this.script.execute((ScriptContext)scriptContext);
            Event resultEvent = this.convert(result, event);
            logger.debug("Result: {}", (Object)resultEvent);
            return resultEvent;
        }
        catch (Exception exception) {
            return event;
        }
    }

    private Event convert(Object result, Event event) {
        logger.debug("Converting result - result: {}, event: {}", result, (Object)event);
        if (result == null) {
            return null;
        }
        if (result instanceof Boolean) {
            return (Boolean)result != false ? event : null;
        }
        if (result instanceof Event) {
            return (Event)result;
        }
        if (result instanceof Event.EventBuilder) {
            return ((Event.EventBuilder)result).build();
        }
        throw new IllegalStateException(String.format("Invalid return type: %s", result.getClass()));
    }
}

