/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.UUID;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.storage.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStorage
implements Storage {
    private static final Logger logger = LoggerFactory.getLogger(BaseStorage.class);
    private static final boolean allowEntryTimestamp = Boolean.getBoolean("org.eclipse.scada.ae.server.storage.allowExternalEntryTimestamp");
    private static final String providedNodeId = System.getProperty("org.eclipse.scada.ae.server.storage.nodeId");
    private final String nodeId = providedNodeId != null ? providedNodeId : BaseStorage.getHostname();

    private static String getHostname() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            logger.warn("Failed to obtain hostname", (Throwable)e);
            return "<unknown>";
        }
    }

    protected String getNodeId() {
        return this.nodeId;
    }

    @Override
    public Event store(Event event) {
        return this.store(event, null);
    }

    protected Event createEvent(Event event) {
        Event.EventBuilder builder = Event.create().event(event).id(UUID.randomUUID());
        Date now = new GregorianCalendar().getTime();
        if (!allowEntryTimestamp || event.getEntryTimestamp() == null) {
            builder.entryTimestamp(now);
        }
        if (event.getSourceTimestamp() == null) {
            builder.sourceTimestamp(now);
        }
        builder.attribute("nodeId", (Object)this.nodeId);
        return builder.build();
    }

    @Override
    public Event update(UUID id, String comment) throws Exception {
        return this.update(id, comment, null);
    }
}

