/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.test.items;

import java.util.EnumSet;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.da.server.common.chain.BaseChainItemCommon;
import org.eclipse.scada.da.server.common.chain.ChainItem;
import org.eclipse.scada.da.server.common.chain.ChainProcessEntry;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.chain.MemoryItemChained;
import org.eclipse.scada.da.server.common.chain.item.SumAlarmChainItem;
import org.eclipse.scada.da.server.common.chain.item.SumErrorChainItem;
import org.eclipse.scada.da.server.common.impl.HiveCommon;

public class MemoryChainedItem
extends MemoryItemChained {
    public static void applyDefaultInputChain(HiveCommon hive, DataItemInputChained item) {
        item.addChainElement(IODirection.INPUT, (ChainItem)new SumErrorChainItem());
        item.addChainElement(IODirection.INPUT, (ChainItem)new SumAlarmChainItem());
    }

    public MemoryChainedItem(HiveCommon hive, String id) {
        super((DataItemInformation)new DataItemInformationBase(id, EnumSet.of(IODirection.INPUT, IODirection.OUTPUT)));
        this.addChainElement(IODirection.INPUT, (ChainItem)new InjectChainItem(this));
        MemoryChainedItem.applyDefaultInputChain(hive, (DataItemInputChained)this);
    }

    public void addChainElement(IODirection direction, String className) throws Exception {
        Class<?> itemClass = Class.forName(className);
        Object o = itemClass.newInstance();
        this.addChainElement(direction, (ChainItem)o);
    }

    public synchronized void removeChainElement(IODirection direction, String className) throws Exception {
        for (ChainProcessEntry entry : this.getChainCopy()) {
            if (!entry.getWhat().getClass().getCanonicalName().equals(className)) continue;
            if (entry.getWhen().equals(EnumSet.of(direction))) {
                this.removeChainElement(entry.getWhen(), entry.getWhat());
            }
            return;
        }
        throw new Exception("Item not found");
    }

    private class InjectChainItem
    extends BaseChainItemCommon {
        private MemoryChainedItem item = null;

        public InjectChainItem(MemoryChainedItem item) {
            this.item = item;
            this.setReservedAttributes(new String[]{"org.eclipse.scada.da.test.chain.value"});
        }

        public Variant process(Variant value, Map<String, Variant> attributes) {
            int i = 0;
            StringBuilder str = new StringBuilder();
            for (ChainProcessEntry item : this.item.getChainCopy()) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(item.getWhat().getClass().getCanonicalName());
                str.append("(");
                str.append(item.getWhen().toString());
                str.append(")");
                ++i;
            }
            attributes.put("org.eclipse.scada.da.test.chain.value", Variant.valueOf((Object)str.toString()));
            return null;
        }
    }
}

