/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.proxy;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.data.HistoricalItemInformation;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.server.common.HistoricalItem;
import org.eclipse.scada.hd.server.proxy.ProxyValueSource;
import org.eclipse.scada.hd.server.proxy.QueryImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class ProxyHistoricalItem
implements HistoricalItem {
    private final String id;
    private final BundleContext context;
    private final Collection<ProxyValueSource> sources = new LinkedList<ProxyValueSource>();
    private Set<QueryImpl> queries = new HashSet<QueryImpl>();
    private final Set<ProxyValueSource.ServiceEntry> items = new HashSet<ProxyValueSource.ServiceEntry>();
    private final Set<ItemListener> listeners = new HashSet<ItemListener>();
    private final Executor executor;

    public ProxyHistoricalItem(BundleContext context, Executor executor, String configurationId, Map<String, String> parameters) {
        this.id = configurationId;
        this.context = context;
        this.executor = executor;
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        String items = cfg.getStringChecked("items", "'items' must be one or more historical items");
        String splitter = cfg.getString("splitter", "[ ,]+");
        int i = 0;
        String[] stringArray = items.split(splitter);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            try {
                this.createItem(item, i);
            }
            catch (Exception e) {
                this.disposeItems();
                throw new RuntimeException("Failed to create item", e);
            }
            ++i;
            ++n2;
        }
    }

    private void disposeItems() {
        for (ProxyValueSource source : this.sources) {
            source.dispose();
        }
        this.sources.clear();
    }

    private void createItem(String item, int priority) throws InvalidSyntaxException {
        ProxyValueSource source = new ProxyValueSource(this.context, item, this, priority);
        this.sources.add(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(QueryParameters parameters, QueryListener listener, boolean updateData) {
        QueryImpl query = new QueryImpl(this, parameters, listener, updateData, this.executor);
        ProxyHistoricalItem proxyHistoricalItem = this;
        synchronized (proxyHistoricalItem) {
            block4: {
                if (this.queries != null) break block4;
                query.close();
                return null;
            }
            this.queries.add(query);
            return query;
        }
    }

    public HistoricalItemInformation getInformation() {
        HashMap properties = new HashMap(1);
        return new HistoricalItemInformation(this.id, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        HashSet<QueryImpl> queries;
        ProxyHistoricalItem proxyHistoricalItem = this;
        synchronized (proxyHistoricalItem) {
            queries = new HashSet<QueryImpl>(this.queries);
            this.queries = null;
        }
        for (QueryImpl query : queries) {
            query.close();
        }
    }

    public synchronized void addListener(final ItemListener listener) {
        if (this.listeners.add(listener)) {
            final HashSet<ProxyValueSource.ServiceEntry> items = new HashSet<ProxyValueSource.ServiceEntry>(this.items);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.listenersChanges(items, Collections.<ProxyValueSource.ServiceEntry>emptyList());
                }
            });
        }
    }

    public synchronized void removeListener(ItemListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void addSource(ProxyValueSource.ServiceEntry service) {
        if (this.items.add(service)) {
            this.notifySources(Arrays.asList(service), Collections.<ProxyValueSource.ServiceEntry>emptyList());
        }
    }

    public synchronized void removeSource(ProxyValueSource.ServiceEntry service) {
        if (this.items.remove(service)) {
            this.notifySources(Collections.<ProxyValueSource.ServiceEntry>emptyList(), Arrays.asList(service));
        }
    }

    private void notifySources(final List<ProxyValueSource.ServiceEntry> added, final List<ProxyValueSource.ServiceEntry> removed) {
        for (final ItemListener listener : this.listeners) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.listenersChanges(added, removed);
                }
            });
        }
    }

    public static interface ItemListener {
        public void listenersChanges(Collection<ProxyValueSource.ServiceEntry> var1, Collection<ProxyValueSource.ServiceEntry> var2);
    }
}

