/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import java.util.concurrent.Executor;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.io.PollRequest;
import org.eclipse.scada.da.server.common.memory.MemoryRequestBlock;
import org.eclipse.scada.da.server.common.memory.RequestBlockConfigurator;
import org.eclipse.scada.da.server.common.memory.Variable;
import org.eclipse.scada.da.server.common.osgi.factory.DataItemFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestBlock
implements PollRequest,
MemoryRequestBlock {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRequestBlock.class);
    private final Statistics statistics;
    private final BundleContext context;
    private final long period;
    private final DataItemFactory blockItemFactory;
    private final DataItemInputChained settingVariablesItem;
    private Variable[] variables;
    private long lastAction;
    private boolean disposed;
    private final String variablePrefix;
    private final String blockPrefix;
    private final RequestBlockConfigurator configurator;
    private final long timeoutQuietPeriod;
    private boolean timeout;
    private final boolean eager;

    public AbstractRequestBlock(BundleContext context, Executor executor, String mainTypeName, String variablePrefix, String blockPrefix, boolean enableStatistics, long period, int requestSize, long timeoutQuietPeriod, boolean eager) {
        this.context = context;
        this.variablePrefix = variablePrefix;
        this.blockPrefix = blockPrefix;
        this.timeoutQuietPeriod = timeoutQuietPeriod;
        this.eager = eager;
        this.period = period;
        this.blockItemFactory = new DataItemFactory(context, executor, blockPrefix);
        this.settingVariablesItem = this.blockItemFactory.createInput("settingVariables", null);
        this.statistics = enableStatistics ? new Statistics(this.blockItemFactory, requestSize) : null;
        this.configurator = new RequestBlockConfigurator(this, mainTypeName);
    }

    protected void initialize() {
        this.configurator.start();
    }

    public Long updatePriority(long now) {
        long priority = this.calculatePriority(now);
        if (!this.eager && priority < 0L) {
            return null;
        }
        return priority;
    }

    protected long calculatePriority(long now) {
        if (this.timeout) {
            return now - this.lastAction - (this.period + this.timeoutQuietPeriod);
        }
        return now - this.lastAction - this.period;
    }

    public synchronized void handleDisconnect() {
        if (this.disposed) {
            return;
        }
        if (this.variables != null) {
            Variable[] variableArray = this.variables;
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                Variable reg = variableArray[n2];
                reg.handleDisconnect();
                ++n2;
            }
        }
    }

    public void handleTimeout() {
        if (this.disposed) {
            return;
        }
        this.lastAction = System.currentTimeMillis();
        this.timeout = true;
        this.statistics.timeout();
        if (this.variables != null) {
            Variable[] variableArray = this.variables;
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                Variable reg = variableArray[n2];
                reg.handleFailure(new RuntimeException("Timeout"));
                ++n2;
            }
        }
    }

    public synchronized void handleFailure(Throwable e) {
        if (this.disposed) {
            return;
        }
        this.lastAction = System.currentTimeMillis();
        this.recordUpdate(true);
        if (this.variables != null) {
            Variable[] variableArray = this.variables;
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                Variable reg = variableArray[n2];
                reg.handleFailure(e);
                ++n2;
            }
        }
    }

    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        logger.info("Disposing: {}", (Object)this);
        this.disposed = true;
        if (this.configurator != null) {
            this.configurator.stop();
        }
        if (this.statistics != null) {
            this.statistics.dispose();
        }
        if (this.blockItemFactory != null) {
            this.blockItemFactory.dispose();
        }
        if (this.variables != null) {
            Variable[] variableArray = this.variables;
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                Variable reg = variableArray[n2];
                reg.stop(this.context);
                ++n2;
            }
        }
    }

    public synchronized void setVariables(Variable[] variables) {
        Variable var;
        int n;
        int n2;
        Variable[] variableArray;
        if (this.disposed) {
            return;
        }
        this.settingVariablesItem.updateData(Variant.TRUE, null, null);
        if (this.variables != null) {
            variableArray = this.variables;
            n2 = this.variables.length;
            n = 0;
            while (n < n2) {
                var = variableArray[n];
                var.stop(this.context);
                ++n;
            }
        }
        this.variables = variables;
        if (this.variables != null) {
            variableArray = this.variables;
            n2 = this.variables.length;
            n = 0;
            while (n < n2) {
                var = variableArray[n];
                var.start(this.variablePrefix, this.context, this, this.getStartAddress());
                ++n;
            }
        }
        this.settingVariablesItem.updateData(Variant.FALSE, null, null);
    }

    protected void recordChecksumError() {
        if (this.statistics != null) {
            this.statistics.addChecksumError();
        }
    }

    protected void recordUpdate(boolean error) {
        this.timeout = false;
        this.lastAction = System.currentTimeMillis();
        if (this.statistics != null) {
            if (error) {
                this.statistics.receivedError(this.lastAction);
            } else {
                this.statistics.receivedUpdate(this.lastAction);
            }
        }
    }

    public synchronized void handleError(int error) {
        if (this.disposed) {
            return;
        }
        this.recordUpdate(true);
        logger.debug("Handle error update - variables: {}", new Object[]{this.variables});
        if (this.variables != null) {
            Variable[] variableArray = this.variables;
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                Variable reg = variableArray[n2];
                reg.handleError(error);
                ++n2;
            }
        }
    }

    public synchronized void handleData(IoBuffer data) {
        if (this.disposed) {
            logger.trace("Block is disposed");
            return;
        }
        this.recordUpdate(false);
        logger.debug("Handle data update - variables: {}", new Object[]{this.variables});
        if (this.variables != null) {
            Variant timestamp = Variant.valueOf((long)System.currentTimeMillis());
            Variable[] variableArray = this.variables;
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                Variable reg = variableArray[n2];
                try {
                    reg.handleData(data, timestamp);
                }
                catch (Exception e) {
                    logger.warn("Failed in block {}", (Object)this.blockPrefix);
                    logger.warn("Failed to handle register", (Throwable)e);
                    reg.handleFailure(e);
                }
                ++n2;
            }
        }
    }

    protected void requestUpdate() {
        this.lastAction = 0L;
    }

    protected static class Statistics {
        private final DataItemInputChained lastUpdateItem;
        private final DataItemInputChained lastTimeDiffItem;
        private long lastUpdate;
        private final CircularFifoBuffer diffBuffer;
        private final DataItemInputChained avgDiffItem;
        private final DataItemInputChained stateItem;
        private final DataItemInputChained sizeItem;
        private final DataItemInputChained timeoutStateItem;
        private final DataItemInputChained checksumErrorsItem;
        private long checksumErrors;

        public Statistics(DataItemFactory itemFactory, int size) {
            this.stateItem = itemFactory.createInput("state", null);
            this.timeoutStateItem = itemFactory.createInput("timeout", null);
            this.lastUpdateItem = itemFactory.createInput("lastUpdate", null);
            this.lastTimeDiffItem = itemFactory.createInput("lastDiff", null);
            this.avgDiffItem = itemFactory.createInput("avgDiff", null);
            this.checksumErrorsItem = itemFactory.createInput("checksumErrors", null);
            this.sizeItem = itemFactory.createInput("size", null);
            this.sizeItem.updateData(Variant.valueOf((int)size), null, null);
            this.lastUpdate = System.currentTimeMillis();
            this.diffBuffer = new CircularFifoBuffer(20);
        }

        public void dispose() {
        }

        public void receivedError(long now) {
            this.tickNow(now);
            this.stateItem.updateData(Variant.FALSE, null, null);
            this.timeoutStateItem.updateData(Variant.FALSE, null, null);
        }

        public void receivedUpdate(long now) {
            this.tickNow(now);
            this.stateItem.updateData(Variant.TRUE, null, null);
            this.timeoutStateItem.updateData(Variant.FALSE, null, null);
        }

        public void timeout() {
            this.stateItem.updateData(Variant.FALSE, null, null);
            this.timeoutStateItem.updateData(Variant.TRUE, null, null);
        }

        public void addChecksumError() {
            ++this.checksumErrors;
            this.checksumErrorsItem.updateData(Variant.valueOf((long)this.checksumErrors), null, null);
        }

        private void tickNow(long now) {
            long diff = now - this.lastUpdate;
            this.lastUpdate = now;
            this.lastUpdateItem.updateData(Variant.valueOf((long)this.lastUpdate), null, null);
            this.lastTimeDiffItem.updateData(Variant.valueOf((long)diff), null, null);
            this.diffBuffer.add((Object)diff);
            this.update();
        }

        private void update() {
            long sum = 0L;
            for (Object o : this.diffBuffer) {
                sum += ((Number)o).longValue();
            }
            double avgDiff = (double)sum / (double)this.diffBuffer.size();
            this.avgDiffItem.updateData(Variant.valueOf((double)avgDiff), null, null);
        }
    }
}

