/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.memory.VariableManager;
import org.eclipse.scada.da.server.common.memory.internal.VariableManagerImpl;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static Activator INSTANCE;
    private VariableManagerImpl variableManager;
    private ExecutorService executor;
    private ObjectPoolImpl<DataItem> itemPool;
    private ServiceRegistration<?> itemPoolHandle;

    public static VariableManager getVariableManager() {
        return Activator.INSTANCE.variableManager;
    }

    public void start(BundleContext context) throws Exception {
        INSTANCE = this;
        this.itemPool = new ObjectPoolImpl();
        this.itemPoolHandle = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.itemPool, DataItem.class);
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(context.getBundle().getSymbolicName()));
        this.variableManager = new VariableManagerImpl(this.executor, (ManageableObjectPool<DataItem>)this.itemPool);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.server.common.memory.types");
        context.registerService(ConfigurationFactory.class.getName(), (Object)this.variableManager, properties);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.variableManager != null) {
            this.variableManager.dispose();
            this.variableManager = null;
        }
        if (this.itemPool != null) {
            this.itemPoolHandle.unregister();
            this.itemPool.dispose();
            this.itemPool = null;
        }
        this.executor.shutdown();
        this.executor = null;
        INSTANCE = null;
    }
}

