/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory.internal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.memory.AbstractAttribute;
import org.eclipse.scada.da.server.common.memory.Attribute;
import org.eclipse.scada.da.server.common.memory.BitAttribute;
import org.eclipse.scada.da.server.common.memory.BitVariable;
import org.eclipse.scada.da.server.common.memory.ByteAttribute;
import org.eclipse.scada.da.server.common.memory.ByteOrder;
import org.eclipse.scada.da.server.common.memory.ByteVariable;
import org.eclipse.scada.da.server.common.memory.DoubleFloatAttribute;
import org.eclipse.scada.da.server.common.memory.DoubleFloatVariable;
import org.eclipse.scada.da.server.common.memory.DoubleIntegerAttribute;
import org.eclipse.scada.da.server.common.memory.DoubleIntegerVariable;
import org.eclipse.scada.da.server.common.memory.FloatAttribute;
import org.eclipse.scada.da.server.common.memory.FloatVariable;
import org.eclipse.scada.da.server.common.memory.Int16Attribute;
import org.eclipse.scada.da.server.common.memory.Int16Variable;
import org.eclipse.scada.da.server.common.memory.Int32Attribute;
import org.eclipse.scada.da.server.common.memory.Int32Variable;
import org.eclipse.scada.da.server.common.memory.Int64Attribute;
import org.eclipse.scada.da.server.common.memory.Int64Variable;
import org.eclipse.scada.da.server.common.memory.Int8Attribute;
import org.eclipse.scada.da.server.common.memory.Int8Variable;
import org.eclipse.scada.da.server.common.memory.TriBitAttribute;
import org.eclipse.scada.da.server.common.memory.UdtVariable;
import org.eclipse.scada.da.server.common.memory.Variable;
import org.eclipse.scada.da.server.common.memory.VariableListener;
import org.eclipse.scada.da.server.common.memory.VariableManager;
import org.eclipse.scada.da.server.common.memory.WordAttribute;
import org.eclipse.scada.da.server.common.memory.WordVariable;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableManagerImpl
implements VariableManager,
ConfigurationFactory {
    private static final Logger logger = LoggerFactory.getLogger(VariableManagerImpl.class);
    private static Map<String, String> typeAliasMap = new HashMap<String, String>();
    private final Multimap<String, VariableListener> listeners = HashMultimap.create();
    private final Multimap<String, String> typeDeps = HashMultimap.create();
    private final Map<String, Collection<TypeEntry>> types = new HashMap<String, Collection<TypeEntry>>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("VariableManager"));
    private final ManageableObjectPool<DataItem> itemPool;

    static {
        typeAliasMap.put("BYTE", TYPE.UINT8.name());
        typeAliasMap.put("WORD", TYPE.UINT16.name());
        typeAliasMap.put("DINT", TYPE.UINT32.name());
    }

    public VariableManagerImpl(Executor executor, ManageableObjectPool<DataItem> itemPool) {
        this.itemPool = itemPool;
    }

    public void dispose() {
        this.executor.shutdown();
    }

    @Override
    public synchronized void addVariableListener(String type, final VariableListener listener) {
        this.listeners.put((Object)type, (Object)listener);
        final Variable[] vars = this.createVariables(type);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                listener.variableConfigurationChanged(vars);
            }
        });
    }

    @Override
    public synchronized void removeVariableListener(String type, VariableListener listener) {
        this.listeners.remove((Object)type, (Object)listener);
    }

    public synchronized void delete(UserInformation userInformation, String configurationId) throws Exception {
        this.types.remove(configurationId);
        this.typeDeps.removeAll((Object)configurationId);
        this.handleTypeChange(configurationId);
    }

    private void fireTypeChange(final String type) {
        logger.debug("Fire type change: {}", (Object)type);
        for (final VariableListener listener : this.listeners.get((Object)type)) {
            final Variable[] vars = this.createVariables(type);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    logger.info("Apply type change: {}", (Object)type);
                    listener.variableConfigurationChanged(vars);
                }
            });
        }
    }

    public synchronized void update(UserInformation userInformation, String configurationId, Map<String, String> properties) throws Exception {
        logger.debug("Adding type: {}", (Object)configurationId);
        ArrayList<TypeEntry> config = new ArrayList<TypeEntry>(this.parseConfig(properties));
        this.types.put(configurationId, config);
        logger.debug("Generate deps:");
        HashSet<String> types = new HashSet<String>();
        for (TypeEntry entry : config) {
            if (entry.getType() != TYPE.UDT) continue;
            logger.debug("'{}' depends on '{}'", new Object[]{configurationId, entry.getTypeName()});
            types.add(entry.getTypeName());
        }
        this.typeDeps.putAll((Object)configurationId, types);
        this.handleTypeChange(configurationId);
    }

    private void handleTypeChange(String configurationId) {
        logger.info("Handle type change: {}", (Object)configurationId);
        this.fireTypeChange(configurationId);
        for (Map.Entry entry : this.typeDeps.asMap().entrySet()) {
            logger.debug(String.format("'%s' depends on '%s'", entry.getKey(), entry.getValue()));
            if (!((Collection)entry.getValue()).contains(configurationId)) continue;
            logger.debug(String.format("Trigger dependency - '%s' depends on '%s'", entry.getKey(), configurationId));
            this.handleTypeChange((String)entry.getKey());
        }
    }

    private Variable[] createVariables(String type) {
        logger.debug("Creating variables for type: {}", (Object)type);
        Collection<TypeEntry> entries = this.types.get(type);
        if (entries == null) {
            return new Variable[0];
        }
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (TypeEntry entry : entries) {
            switch (entry.getType()) {
                case BIT: {
                    result.add(new BitVariable(entry.getName(), entry.getIndex(), entry.getSubIndex(), this.executor, this.itemPool, this.createAttributes(entry)));
                    break;
                }
                case UINT8: {
                    result.add(new ByteVariable(entry.getName(), entry.getIndex(), this.executor, this.itemPool, this.createAttributes(entry)));
                    break;
                }
                case FLOAT: {
                    result.add(new FloatVariable(entry.getName(), entry.getIndex(), this.executor, this.itemPool, this.createAttributes(entry)));
                    break;
                }
                case UINT16: {
                    result.add(new WordVariable(entry.getName(), entry.getIndex(), entry.getOrder(), (Executor)this.executor, this.itemPool, this.createAttributes(entry)));
                    break;
                }
                case UINT32: {
                    result.add(new DoubleIntegerVariable(entry.getName(), entry.getIndex(), entry.getOrder(), (Executor)this.executor, this.itemPool, this.createAttributes(entry)));
                    break;
                }
                case UDT: {
                    result.add(new UdtVariable(entry.getName(), entry.getIndex(), this.createVariables(entry.getTypeName())));
                    break;
                }
                case INT8: {
                    result.add(new Int8Variable(entry.getName(), entry.getIndex(), this.executor, this.itemPool, this.createAttributes(entry)));
                    break;
                }
                case INT16: {
                    result.add(new Int16Variable(entry.getName(), entry.getIndex(), entry.getOrder(), (Executor)this.executor, this.itemPool, this.createAttributes(entry)));
                    break;
                }
                case INT32: {
                    result.add(new Int32Variable(entry.getName(), entry.getIndex(), entry.getOrder(), (Executor)this.executor, this.itemPool, this.createAttributes(entry)));
                    break;
                }
                case INT64: {
                    result.add(new Int64Variable(entry.getName(), entry.getIndex(), entry.getOrder(), (Executor)this.executor, this.itemPool, this.createAttributes(entry)));
                    break;
                }
                case DOUBLE: {
                    result.add(new DoubleFloatVariable(entry.getName(), entry.getIndex(), this.executor, this.itemPool, this.createAttributes(entry)));
                    break;
                }
                case TRIBIT: {
                    throw new IllegalArgumentException(String.format("TRIBIT variables are not supported right now", new Object[0]));
                }
            }
        }
        return result.toArray(new Variable[result.size()]);
    }

    private Attribute[] createAttributes(TypeEntry entry) {
        logger.debug("Creating attributes for {}", (Object)entry);
        LinkedList<AbstractAttribute> result = new LinkedList<AbstractAttribute>();
        TypeEntry[] typeEntryArray = entry.getAttributes();
        int n = typeEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeEntry attrEntry = typeEntryArray[n2];
            logger.debug("Creating attribute: {}", (Object)attrEntry);
            switch (attrEntry.getType()) {
                case BIT: {
                    result.add(new BitAttribute(attrEntry.getName(), attrEntry.getIndex(), attrEntry.getSubIndex(), attrEntry.getIndexes()[2] != 0));
                    break;
                }
                case FLOAT: {
                    result.add(new FloatAttribute(attrEntry.getName(), attrEntry.getIndex(), attrEntry.getIndexes()[1] != 0));
                    break;
                }
                case TRIBIT: {
                    int[] index = attrEntry.getIndexes();
                    result.add(new TriBitAttribute(attrEntry.getName(), index[0], index[1], index[2], index[3], index[4], index[5], index[6] != 0, index[7] != 0));
                    break;
                }
                case UINT8: {
                    result.add(new ByteAttribute(attrEntry.getName(), attrEntry.getIndex(), attrEntry.getIndexes()[1] != 0));
                    break;
                }
                case UINT16: {
                    result.add(new WordAttribute(attrEntry.getName(), attrEntry.getIndex(), attrEntry.getOrder(), attrEntry.getIndexes()[1] != 0));
                    break;
                }
                case UINT32: {
                    result.add(new DoubleIntegerAttribute(attrEntry.getName(), attrEntry.getIndex(), attrEntry.getOrder(), attrEntry.getIndexes()[1] != 0));
                    break;
                }
                case INT8: {
                    result.add(new Int8Attribute(attrEntry.getName(), attrEntry.getIndex(), attrEntry.getIndexes()[1] != 0));
                    break;
                }
                case INT16: {
                    result.add(new Int16Attribute(attrEntry.getName(), attrEntry.getIndex(), attrEntry.getOrder(), attrEntry.getIndexes()[1] != 0));
                    break;
                }
                case INT32: {
                    result.add(new Int32Attribute(attrEntry.getName(), attrEntry.getIndex(), attrEntry.getOrder(), attrEntry.getIndexes()[1] != 0));
                    break;
                }
                case INT64: {
                    result.add(new Int64Attribute(attrEntry.getName(), attrEntry.getIndex(), attrEntry.getOrder(), attrEntry.getIndexes()[1] != 0));
                    break;
                }
                case DOUBLE: {
                    result.add(new DoubleFloatAttribute(attrEntry.getName(), attrEntry.getIndex(), attrEntry.getIndexes()[1] != 0));
                    break;
                }
            }
            ++n2;
        }
        return result.toArray(new Attribute[result.size()]);
    }

    private Collection<TypeEntry> parseConfig(Map<String, String> properties) {
        LinkedList<TypeEntry> result = new LinkedList<TypeEntry>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("variable.")) continue;
            String varName = key.substring("variable.".length());
            String[] toks = entry.getValue().split(":");
            this.parseType(properties, result, varName, toks[0], this.makeArgs(toks, 1), false);
        }
        return result;
    }

    protected String[] makeArgs(String[] toks, int start) {
        String[] args = new String[toks.length - start];
        int i = start;
        while (i < toks.length) {
            args[i - start] = toks[i];
            ++i;
        }
        return args;
    }

    protected void parseType(Map<String, String> properties, Collection<TypeEntry> result, String varName, String typeName, String[] args, boolean attribute) {
        switch (this.typeValue(typeName)) {
            case BIT: {
                result.add(new TypeEntry(varName, Integer.parseInt(args[0]), Integer.parseInt(args[1]), Integer.parseInt(args[1]), this.parseAttributes(attribute, properties, varName)));
                break;
            }
            case FLOAT: {
                result.add(new TypeEntry(varName, TYPE.FLOAT, Integer.parseInt(args[0]), Integer.parseInt(args[1]), null, this.parseAttributes(attribute, properties, varName)));
                break;
            }
            case DOUBLE: {
                result.add(new TypeEntry(varName, TYPE.DOUBLE, Integer.parseInt(args[0]), Integer.parseInt(args[1]), null, this.parseAttributes(attribute, properties, varName)));
                break;
            }
            case UINT8: {
                result.add(new TypeEntry(varName, TYPE.UINT8, Integer.parseInt(args[0]), Integer.parseInt(args[1]), null, this.parseAttributes(attribute, properties, varName)));
                break;
            }
            case UINT16: {
                result.add(new TypeEntry(varName, TYPE.UINT16, Integer.parseInt(args[0]), Integer.parseInt(args[1]), this.makeOrder(args), this.parseAttributes(attribute, properties, varName)));
                break;
            }
            case UINT32: {
                result.add(new TypeEntry(varName, TYPE.UINT32, Integer.parseInt(args[0]), Integer.parseInt(args[1]), this.makeOrder(args), this.parseAttributes(attribute, properties, varName)));
                break;
            }
            case INT8: {
                result.add(new TypeEntry(varName, TYPE.INT8, Integer.parseInt(args[0]), Integer.parseInt(args[1]), null, this.parseAttributes(attribute, properties, varName)));
                break;
            }
            case INT16: {
                result.add(new TypeEntry(varName, TYPE.INT16, Integer.parseInt(args[0]), Integer.parseInt(args[1]), this.makeOrder(args), this.parseAttributes(attribute, properties, varName)));
                break;
            }
            case INT32: {
                result.add(new TypeEntry(varName, TYPE.INT32, Integer.parseInt(args[0]), Integer.parseInt(args[1]), this.makeOrder(args), this.parseAttributes(attribute, properties, varName)));
                break;
            }
            case INT64: {
                result.add(new TypeEntry(varName, TYPE.INT64, Integer.parseInt(args[0]), Integer.parseInt(args[1]), this.makeOrder(args), this.parseAttributes(attribute, properties, varName)));
                break;
            }
            case UDT: {
                if (attribute) {
                    throw new IllegalArgumentException("Attribute must be of scalar type. UDTs are not allowed.");
                }
                result.add(new TypeEntry(varName, args[1], Integer.parseInt(args[0])));
                break;
            }
            case TRIBIT: {
                result.add(new TypeEntry(varName, new int[]{Integer.parseInt(args[0]), Integer.parseInt(args[1]), Integer.parseInt(args[2]), Integer.parseInt(args[3]), Integer.parseInt(args[4]), Integer.parseInt(args[5]), Integer.parseInt(args[6]), Integer.parseInt(args[7])}, new TypeEntry[0]));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Type %s is not supported at the moment", typeName));
            }
        }
    }

    private TYPE typeValue(String typeName) {
        try {
            return TYPE.valueOf(typeName);
        }
        catch (Exception exception) {
            return TYPE.valueOf(typeAliasMap.get(typeName));
        }
    }

    private ByteOrder makeOrder(String[] args) {
        if (args.length < 2) {
            return ByteOrder.DEFAULT;
        }
        if (args[2].isEmpty()) {
            return ByteOrder.DEFAULT;
        }
        return ByteOrder.valueOf(args[2]);
    }

    private TypeEntry[] parseAttributes(boolean attribute, Map<String, String> properties, String varName) {
        if (attribute) {
            return new TypeEntry[0];
        }
        String attrVarName = "attribute." + varName + ".";
        LinkedList<TypeEntry> result = new LinkedList<TypeEntry>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(attrVarName)) continue;
            String attrName = key.substring(attrVarName.length());
            String[] toks = entry.getValue().split(":");
            String typeName = toks[0];
            String[] args = this.makeArgs(toks, 1);
            this.parseType(properties, result, attrName, typeName, args, true);
        }
        return result.toArray(new TypeEntry[0]);
    }

    private static enum TYPE {
        BIT,
        TRIBIT,
        UINT8,
        FLOAT,
        UINT16,
        UINT32,
        UDT,
        INT8,
        INT16,
        INT32,
        INT64,
        DOUBLE;

    }

    private static class TypeEntry {
        private final String name;
        private final TYPE type;
        private String typeName;
        private final int[] index;
        private ByteOrder order;
        private final TypeEntry[] attributes;

        public TypeEntry(String name, String typeName, int index) {
            this.name = name;
            this.type = TYPE.UDT;
            this.typeName = typeName;
            this.attributes = null;
            this.index = new int[]{index};
        }

        public TypeEntry(String name, int[] index, TypeEntry ... attributes) {
            this.name = name;
            this.index = (int[])index.clone();
            this.type = TYPE.TRIBIT;
            this.attributes = attributes;
        }

        public TypeEntry(String name, int index, int subIndex, int options, TypeEntry ... attributes) {
            this.name = name;
            this.index = new int[]{index, subIndex, options};
            this.type = TYPE.BIT;
            this.attributes = attributes;
        }

        public TypeEntry(String name, TYPE type, int index, int options, ByteOrder order, TypeEntry ... attributes) {
            this.name = name;
            this.index = new int[]{index, options};
            this.order = order;
            this.type = type;
            this.attributes = attributes;
        }

        public int[] getIndexes() {
            return this.index;
        }

        public TypeEntry[] getAttributes() {
            return this.attributes;
        }

        public int getIndex() {
            return this.index[0];
        }

        public String getName() {
            return this.name;
        }

        public int getSubIndex() {
            return this.index[1];
        }

        public TYPE getType() {
            return this.type;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String toString() {
            switch (this.type) {
                // Empty switch
            }
            return String.format("%s:%s", new Object[]{this.name, this.type});
        }

        public ByteOrder getOrder() {
            return this.order;
        }
    }
}

