/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage.postgres.internal;

import java.util.Calendar;
import org.eclipse.scada.ae.server.storage.postgres.JdbcDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanUpJob
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CleanUpJob.class);
    private final JdbcDao jdbcDao;

    public CleanUpJob(JdbcDao jdbcDao) {
        this.jdbcDao = jdbcDao;
    }

    public static long getCleanupPeriod() {
        return Long.getLong("org.eclipse.scada.ae.server.storage.jdbc.cleanupPeriodSeconds", 3600L);
    }

    @Override
    public void run() {
        try {
            int entriesDeleted = this.cleanupArchive(this.getCleanupDays());
            logger.info("Deleted {} entries", (Object)entriesDeleted);
        }
        catch (Exception e) {
            logger.error("Failed to clean up archive", (Throwable)e);
        }
    }

    private int cleanupArchive(int days) throws Exception {
        logger.info("Request to clean up archive - days: {}", (Object)days);
        if (days <= 0) {
            logger.info("Skipping archive cleanup");
            return -1;
        }
        Calendar c = Calendar.getInstance();
        c.add(5, -days);
        return this.jdbcDao.cleanUp(c.getTime());
    }

    private int getCleanupDays() {
        return Integer.getInteger("org.eclipse.scada.ae.server.storage.jdbc.archiveDays", -1);
    }
}

