/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage.postgres.internal;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.scada.ae.server.storage.postgres.NotSupportedException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.utils.filter.Assertion;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.filter.FilterAssertion;
import org.eclipse.scada.utils.filter.FilterExpression;
import org.eclipse.scada.utils.filter.Operator;
import org.eclipse.scada.utils.str.StringHelper;

public class SqlConverter {
    private static final DateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    private static final Map<String, String> fixedFields = new HashMap<String, String>(3);

    static {
        fixedFields.put("id", "ID");
        fixedFields.put("sourceTimestamp", "SOURCE_TIMESTAMP");
        fixedFields.put("entryTimestamp", "ENTRY_TIMESTAMP");
    }

    public static SqlCondition toSql(String schema, Filter filter) throws NotSupportedException {
        AtomicInteger j = new AtomicInteger(0);
        SqlCondition condition = new SqlCondition();
        if (!filter.isEmpty()) {
            if (filter.isExpression()) {
                SqlCondition expression = SqlConverter.toSql(schema, (FilterExpression)filter, j);
                condition.condition = String.valueOf(condition.condition) + " AND " + expression.condition;
                condition.parameters.addAll(expression.parameters);
            } else if (filter.isAssertion()) {
                SqlCondition assertion = SqlConverter.toSql(schema, (FilterAssertion)filter, j);
                condition.condition = String.valueOf(condition.condition) + " AND " + assertion.condition;
                condition.parameters.addAll(assertion.parameters);
            }
        }
        return condition;
    }

    private static SqlCondition toSql(String schema, FilterAssertion assertion, AtomicInteger j) throws NotSupportedException {
        SqlCondition result = null;
        if (assertion.getAssertion() == Assertion.EQUALITY) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), "=", assertion.getValue(), j);
        } else if (assertion.getAssertion() == Assertion.GREATEREQ) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), ">=", assertion.getValue(), j);
        } else if (assertion.getAssertion() == Assertion.GREATERTHAN) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), ">", assertion.getValue(), j);
        } else if (assertion.getAssertion() == Assertion.LESSEQ) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), "<=", assertion.getValue(), j);
        } else if (assertion.getAssertion() == Assertion.LESSTHAN) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), "<", assertion.getValue(), j);
        } else if (assertion.getAssertion() == Assertion.APPROXIMATE) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), "approximate", assertion.getValue(), j);
        } else if (assertion.getAssertion() == Assertion.SUBSTRING) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), "like", assertion.getValue(), j);
        } else if (assertion.getAssertion() == Assertion.PRESENCE) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), "presence", assertion.getValue(), j);
        } else {
            throw new NotSupportedException();
        }
        return result;
    }

    private static SqlCondition toSql(String schema, String attribute, String op, Object value, AtomicInteger j) throws NotSupportedException {
        SqlCondition condition = new SqlCondition();
        Variant v = SqlConverter.toVariant(value);
        if (fixedFields.keySet().contains(attribute)) {
            String column = fixedFields.get(attribute);
            Object param = null;
            if ("sourceTimestamp".equals(attribute) || "entryTimestamp".equals(attribute)) {
                try {
                    param = new Timestamp(isoDateFormat.parse(v.asString("")).getTime());
                }
                catch (ParseException parseException) {
                    param = v.asString("");
                }
            } else if ("id".equals(attribute)) {
                try {
                    param = UUID.fromString(v.asString(""));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    param = v.asString("");
                }
            }
            if ("approximate".equals(op)) {
                throw new NotSupportedException(String.format("approximate query for %s doesn't make any sense", attribute));
            }
            if ("like".equals(op) && param instanceof String) {
                condition.condition = String.format(" lower(%s::TEXT) ilike lower(?::TEXT)", column);
                condition.parameters.add((Serializable)((Object)v.asString("")));
            } else {
                if ("presence".equals(op)) {
                    throw new NotSupportedException(String.format("test for null query for %s doesn't make any sense", attribute));
                }
                if (v.isInteger() || v.isLong()) {
                    condition.condition = String.format(" %s::BIGINT %s ?::BIGINT", column, op);
                    condition.parameters.add(v.asLong(Long.valueOf(0L)));
                } else if (v.isDouble()) {
                    condition.condition = String.format(" %s::DOUBLE %s ?::DOUBLE", column, op);
                    condition.parameters.add(v.asDouble(Double.valueOf(0.0)));
                } else if (v.isBoolean()) {
                    condition.condition = String.format(" %s::BOOLEAN %s ?::BOOLEAN", column, op);
                    condition.parameters.add(v.asBoolean(Boolean.valueOf(false)));
                } else {
                    if (v.isNull()) {
                        throw new NotSupportedException(String.format("test for null query for %s doesn't make any sense", attribute));
                    }
                    if (param instanceof String) {
                        condition.condition = String.format(" %s::TEXT %s ?::TEXT", column, op);
                        condition.parameters.add((Serializable)((Object)v.asString("")));
                    } else {
                        condition.condition = String.format(" %s %s ?", column, op);
                        condition.parameters.add((Serializable)param);
                    }
                }
            }
        } else if ("approximate".equals(op)) {
            condition.condition = String.format(" dmetaphone(es_variant_to_string(DATA -> ?)) = dmetaphone(?) OR dmetaphone_alt(es_variant_to_string(DATA -> ?)) = dmetaphone_alt(?)", attribute);
            condition.parameters.add((Serializable)((Object)attribute));
            condition.parameters.add((Serializable)((Object)v.asString("")));
            condition.parameters.add((Serializable)((Object)attribute));
            condition.parameters.add((Serializable)((Object)v.asString("")));
        } else if ("like".equals(op)) {
            condition.condition = String.format(" lower(es_variant_to_string(DATA -> ?)) ilike lower(?)", new Object[0]);
            condition.parameters.add((Serializable)((Object)attribute));
            condition.parameters.add((Serializable)((Object)v.asString("")));
        } else if ("presence".equals(op)) {
            condition.condition = String.format(" (DATA -> ?) IS NOT NULL", new Object[0]);
            condition.parameters.add((Serializable)((Object)attribute));
        } else if (v.isInteger() || v.isLong()) {
            condition.condition = String.format("  es_variant_to_long(DATA -> ?) %s ?", op);
            condition.parameters.add((Serializable)((Object)attribute));
            condition.parameters.add(v.asLong(Long.valueOf(0L)));
        } else if (v.isDouble()) {
            condition.condition = String.format("  es_variant_to_double(DATA -> ?) %s ?", op);
            condition.parameters.add((Serializable)((Object)attribute));
            condition.parameters.add(v.asDouble(Double.valueOf(0.0)));
        } else if (v.isBoolean()) {
            condition.condition = String.format("  es_variant_to_boolean(DATA -> ?) %s ?", op);
            condition.parameters.add((Serializable)((Object)attribute));
            condition.parameters.add(v.asBoolean(Boolean.valueOf(false)));
        } else if (v.isNull()) {
            condition.condition = String.format(" (DATA -> ?) IS NULL", new Object[0]);
            condition.parameters.add((Serializable)((Object)attribute));
        } else {
            condition.condition = String.format("  lower(es_variant_to_string(DATA -> ?)) %s ?", op);
            condition.parameters.add((Serializable)((Object)attribute));
            condition.parameters.add((Serializable)((Object)v.asString("")));
        }
        j.getAndIncrement();
        return condition;
    }

    private static Variant toVariant(Object value) {
        if (value instanceof List) {
            value = StringHelper.join((Collection)((List)value), (String)"%").replaceAll("\\?", "_");
        }
        if (value instanceof String && ((String)value).contains("#")) {
            try {
                return VariantEditor.toVariant((String)((String)value));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return Variant.valueOf((Object)value);
    }

    static SqlCondition toSql(String schema, FilterExpression expression, AtomicInteger j) throws NotSupportedException {
        SqlCondition result = new SqlCondition();
        result.condition = "(";
        int i = 0;
        for (Filter term : expression.getFilterSet()) {
            SqlCondition r;
            if (i > 0) {
                if (expression.getOperator() == Operator.AND) {
                    result.condition = String.valueOf(result.condition) + " AND ";
                } else if (expression.getOperator() == Operator.OR) {
                    result.condition = String.valueOf(result.condition) + " OR ";
                }
            }
            if (term.isExpression()) {
                r = SqlConverter.toSql(schema, (FilterExpression)term, j);
                result.condition = String.valueOf(result.condition) + r.condition;
                result.parameters.addAll(r.parameters);
            } else if (term.isAssertion()) {
                r = SqlConverter.toSql(schema, (FilterAssertion)term, j);
                result.condition = String.valueOf(result.condition) + r.condition;
                result.parameters.addAll(r.parameters);
            }
            ++i;
        }
        if (expression.getOperator() == Operator.NOT) {
            result.condition = "NOT " + result.condition;
        }
        result.condition = String.valueOf(result.condition) + ")";
        return result;
    }

    public static class SqlCondition {
        public String condition = "";
        public List<Serializable> parameters = new ArrayList<Serializable>();

        public String toString() {
            return String.valueOf(this.condition) + " (params = " + this.parameters + ")";
        }
    }
}

