/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common;

import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.ItemListener;
import org.eclipse.scada.da.server.common.SuspendableDataItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataItemBase
implements DataItem {
    private static final Logger logger = LoggerFactory.getLogger(DataItemBase.class);
    protected ItemListener listener;
    private final DataItemInformation information;

    public DataItemBase(DataItemInformation information) {
        this.information = information;
    }

    @Override
    public DataItemInformation getInformation() {
        return this.information;
    }

    @Override
    public synchronized void setListener(ItemListener listener) {
        if (this.listener != listener) {
            this.handleListenerChange(listener);
        }
    }

    protected synchronized void handleListenerChange(ItemListener listener) {
        if (listener == null) {
            if (this instanceof SuspendableDataItem) {
                ((SuspendableDataItem)((Object)this)).suspend();
            }
            this.listener = null;
        } else if (this.listener == null) {
            this.listener = listener;
            if (this instanceof SuspendableDataItem) {
                ((SuspendableDataItem)((Object)this)).wakeup();
            }
        } else {
            this.listener = listener;
        }
        if (this.listener != null) {
            Map<String, Variant> cacheAttributes;
            Variant cacheValue = this.getCacheValue();
            if (cacheValue != null && cacheValue.isNull()) {
                cacheValue = null;
            }
            if ((cacheAttributes = this.getCacheAttributes()) != null && cacheAttributes.isEmpty()) {
                cacheAttributes = null;
            }
            if (cacheValue != null || cacheAttributes != null) {
                this.notifyData(cacheValue, cacheAttributes, true);
            }
        }
    }

    protected Variant getCacheValue() {
        return null;
    }

    protected Map<String, Variant> getCacheAttributes() {
        return null;
    }

    protected void notifyData(Variant value, Map<String, Variant> attributes) {
        this.notifyData(value, attributes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyData(Variant value, Map<String, Variant> attributes, boolean cache) {
        ItemListener listener;
        logger.debug("Notify data - value: {}, attributes: {}, cache: {}", new Object[]{value, attributes, cache});
        DataItemBase dataItemBase = this;
        synchronized (dataItemBase) {
            listener = this.listener;
        }
        if (listener != null) {
            listener.dataChanged(this, value, attributes, cache);
        }
    }
}

