/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.ngp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Set;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.eclipse.scada.core.server.common.NetworkHelper;
import org.eclipse.scada.core.server.ngp.ServerBaseHandler;
import org.eclipse.scada.core.server.ngp.ServerConnection;
import org.eclipse.scada.protocol.ngp.common.FilterChainBuilder;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerBase {
    private static final Logger logger = LoggerFactory.getLogger(ServerBase.class);
    private final NioSocketAcceptor acceptor;
    private final Collection<InetSocketAddress> addresses;
    private final FilterChainBuilder chainBuilder;

    public ServerBase(Collection<InetSocketAddress> addresses, ProtocolConfigurationFactory protocolConfigurationFactory) throws Exception {
        this.addresses = addresses;
        this.acceptor = new NioSocketAcceptor();
        this.acceptor.setReuseAddress(true);
        this.chainBuilder = new FilterChainBuilder(false);
        this.chainBuilder.setLoggerName(String.valueOf(ServerBase.class.getName()) + ".protocol");
        this.acceptor.setFilterChainBuilder((IoFilterChainBuilder)this.chainBuilder);
        this.acceptor.setHandler((IoHandler)new ServerBaseHandler(this, protocolConfigurationFactory.createConfiguration(false)));
    }

    public Set<InetSocketAddress> start() throws IOException {
        logger.info("Starting server for: {}", this.addresses);
        this.acceptor.bind(this.addresses);
        return NetworkHelper.getLocalAddresses((IoAcceptor)this.acceptor);
    }

    public void stop() {
        this.acceptor.unbind();
    }

    public void dispose() {
        this.acceptor.dispose();
        this.chainBuilder.dispose();
    }

    public abstract ServerConnection createNewConnection(IoSession var1);
}

