/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.base;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceListener;
import org.eclipse.scada.da.datasource.SingleDataSourceTracker;
import org.eclipse.scada.da.datasource.base.AbstractDataSource;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceHandler
extends AbstractDataSource {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDataSourceHandler.class);
    private final ObjectPoolTracker<DataSource> poolTracker;
    private SingleDataSourceTracker tracker;
    private final SingleDataSourceTracker.ServiceListener serviceListener;
    private DataSource dataSource;
    private final DataSourceListener dataSourceListener;
    private final Lock dataSourceReadLock;
    private final Lock dataSourceWriteLock;
    private final Lock trackerLock;

    public AbstractDataSourceHandler(ObjectPoolTracker<DataSource> poolTracker) {
        this.poolTracker = poolTracker;
        this.serviceListener = new SingleDataSourceTracker.ServiceListener(){

            @Override
            public void dataSourceChanged(DataSource dataSource) {
                AbstractDataSourceHandler.this.setDataSource(dataSource);
            }
        };
        this.dataSourceListener = new DataSourceListener(){

            @Override
            public void stateChanged(DataItemValue value) {
                AbstractDataSourceHandler.this.stateChanged(value);
            }
        };
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.dataSourceReadLock = lock.readLock();
        this.dataSourceWriteLock = lock.writeLock();
        this.trackerLock = new ReentrantLock();
    }

    protected abstract void stateChanged(DataItemValue var1);

    protected void setDataSource(DataSource dataSource) {
        logger.debug("Set datasource: {}", (Object)dataSource);
        try {
            this.dataSourceWriteLock.lock();
            if (this.dataSource != null) {
                this.dataSource.removeListener(this.dataSourceListener);
                this.dataSource = null;
                this.stateChanged(null);
            }
            this.dataSource = dataSource;
            if (this.dataSource != null) {
                this.dataSource.addListener(this.dataSourceListener);
            }
        }
        finally {
            this.dataSourceWriteLock.unlock();
        }
    }

    protected DataSource getDataSource() {
        try {
            this.dataSourceReadLock.lock();
            DataSource dataSource = this.dataSource;
            return dataSource;
        }
        finally {
            this.dataSourceReadLock.unlock();
        }
    }

    protected void setDataSource(String dataSourceId) throws InvalidSyntaxException {
        logger.debug("Set datasource request: {}", (Object)dataSourceId);
        try {
            this.trackerLock.lock();
            if (this.tracker != null) {
                this.tracker.close();
                this.tracker = null;
            }
            if (dataSourceId != null) {
                this.tracker = new SingleDataSourceTracker(this.poolTracker, dataSourceId, this.serviceListener);
                this.tracker.open();
            }
        }
        finally {
            this.trackerLock.unlock();
        }
    }

    public void dispose() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }
}

