/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.provider.jdbc;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.sec.provider.jdbc.JdbcAuthenticationServiceFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private static BundleContext context;
    private JdbcAuthenticationServiceFactory serviceFactory;
    private ServiceRegistration<ConfigurationFactory> handle;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        logger.info("Starting JDBC Security Provider");
        this.serviceFactory = new JdbcAuthenticationServiceFactory(bundleContext);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "A JDBC authentication service");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", String.valueOf(bundleContext.getBundle().getSymbolicName()) + ".authenticator");
        this.handle = bundleContext.registerService(ConfigurationFactory.class, (Object)this.serviceFactory, properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        logger.info("Stopping JDBC Security Provider");
        context = null;
        if (this.handle != null) {
            this.handle.unregister();
            this.handle = null;
        }
        if (this.serviceFactory != null) {
            this.serviceFactory.dispose();
            this.serviceFactory = null;
        }
    }
}

