/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.proxy.item;

import java.util.Collections;
import java.util.Map;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.client.NoConnectionException;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.core.server.OperationParametersHelper;
import org.eclipse.scada.da.client.WriteAttributeOperationCallback;
import org.eclipse.scada.da.client.WriteOperationCallback;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.server.proxy.connection.ProxySubConnection;
import org.eclipse.scada.da.server.proxy.item.ProxyItemSupport;
import org.eclipse.scada.da.server.proxy.item.ProxyWriteHandler;
import org.eclipse.scada.da.server.proxy.utils.ProxyPrefixName;
import org.eclipse.scada.da.server.proxy.utils.ProxySubConnectionId;
import org.eclipse.scada.da.server.proxy.utils.ProxyUtils;
import org.eclipse.scada.utils.concurrent.AbstractFuture;

public class ProxyWriteHandlerImpl
extends ProxyItemSupport
implements ProxyWriteHandler {
    protected final Map<ProxySubConnectionId, ProxySubConnection> subConnections;

    public ProxyWriteHandlerImpl(String separator, ProxyPrefixName prefix, Map<ProxySubConnectionId, ProxySubConnection> subConnections, ProxySubConnectionId currentConnection, String proxyItemId) {
        super(separator, prefix, currentConnection, proxyItemId);
        this.subConnections = Collections.unmodifiableMap(subConnections);
    }

    @Override
    public void write(String itemId, Variant value, OperationParameters operationParameters) throws NoConnectionException, OperationException {
        ProxySubConnection subConnection = this.subConnections.get(this.currentConnection);
        String actualItemId = ProxyUtils.originalItemId(itemId, this.separator, this.prefix, subConnection.getPrefix());
        ValueResultHandler callback = new ValueResultHandler();
        subConnection.getConnection().write(actualItemId, value, OperationParametersHelper.toData((OperationParameters)operationParameters), (WriteOperationCallback)callback);
        try {
            callback.get();
        }
        catch (Exception e) {
            throw new OperationException((Throwable)e);
        }
    }

    @Override
    public void writeAttributes(String itemId, Map<String, Variant> attributes, WriteAttributeResults writeAttributeResults, OperationParameters operationParameters) {
        WriteAttributeResults actualWriteAttributeResults;
        ProxySubConnection subConnection = this.subConnections.get(this.currentConnection);
        String actualItemId = ProxyUtils.originalItemId(itemId, this.separator, this.prefix, subConnection.getPrefix());
        AttributeResultHandler callback = new AttributeResultHandler();
        try {
            subConnection.getConnection().writeAttributes(actualItemId, attributes, OperationParametersHelper.toData((OperationParameters)operationParameters), (WriteAttributeOperationCallback)callback);
            actualWriteAttributeResults = (WriteAttributeResults)callback.get();
        }
        catch (Exception e) {
            actualWriteAttributeResults = this.attributesCouldNotBeWritten(attributes, e);
        }
        writeAttributeResults.putAll((Map)actualWriteAttributeResults);
    }

    private WriteAttributeResults attributesCouldNotBeWritten(Map<String, Variant> attributes, Exception e) {
        WriteAttributeResults results = new WriteAttributeResults();
        for (String name : attributes.keySet()) {
            results.put((Object)name, (Object)new WriteAttributeResult((Throwable)e));
        }
        return results;
    }

    public static class AttributeResultHandler
    extends AbstractFuture<WriteAttributeResults>
    implements WriteAttributeOperationCallback {
        public void failed(String error) {
            this.setError(new RuntimeException(error).fillInStackTrace());
        }

        public void error(Throwable e) {
            this.setError(e);
        }

        public void complete(WriteAttributeResults result) {
            this.setResult(result);
        }
    }

    public static class ValueResultHandler
    extends AbstractFuture<Void>
    implements WriteOperationCallback {
        public void failed(String error) {
            this.setError(new RuntimeException(error).fillInStackTrace());
        }

        public void error(Throwable e) {
            this.setError(e);
        }

        public void complete() {
            this.setResult(null);
        }
    }
}

