/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.arduino;

import java.util.HashMap;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.chain.DataItemInputOutputChained;
import org.eclipse.scada.protocol.arduino.ArduinoDevice;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class ArduinoDataItem
extends DataItemInputOutputChained {
    private final ArduinoDevice device;
    private final short itemIndex;

    public ArduinoDataItem(ArduinoDevice device, short itemIndex, DataItemInformation information, Executor executor) {
        super(information, executor);
        this.device = device;
        this.itemIndex = itemIndex;
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(1);
        attributes.put("itemIndex", Variant.valueOf((int)itemIndex));
        this.updateData(null, attributes, AttributeMode.SET);
    }

    protected NotifyFuture<WriteResult> startWriteCalculatedValue(Variant value, OperationParameters operationParameters) {
        try {
            this.device.sendWrite(this.itemIndex, (Object)value.as(null));
        }
        catch (Exception e) {
            return new InstantErrorFuture((Throwable)e);
        }
        return new InstantFuture((Object)WriteResult.OK);
    }
}

