/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.arduino;

import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.arduino.ArduinoDataItem;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.protocol.arduino.ArduinoDeviceListener;
import org.eclipse.scada.protocol.arduino.DeviceState;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.osgi.framework.BundleContext;

public class ArduinoDevice {
    private final org.eclipse.scada.protocol.arduino.ArduinoDevice device;
    private final ObjectPoolImpl<DataItem> itemPool;
    private final Executor executor;
    private final String alias;
    private final DataItemInputChained deviceStateItem;
    private final DataItemInputChained stateItem;
    private ArduinoDataItem[] items;

    public ArduinoDevice(BundleContext context, String configurationId, Map<String, String> parameters, ObjectPoolImpl<DataItem> itemPool, Executor executor) {
        this.itemPool = itemPool;
        this.executor = executor;
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.alias = cfg.getString("alias", configurationId);
        this.deviceStateItem = new DataItemInputChained((DataItemInformation)new DataItemInformationBase(this.makeId("deviceState"), EnumSet.of(IODirection.INPUT)), executor);
        itemPool.addService(this.deviceStateItem.getInformation().getName(), (Object)this.deviceStateItem, null);
        this.stateItem = new DataItemInputChained((DataItemInformation)new DataItemInformationBase(this.makeId("state"), EnumSet.of(IODirection.INPUT)), executor);
        itemPool.addService(this.stateItem.getInformation().getName(), (Object)this.stateItem, null);
        this.device = new org.eclipse.scada.protocol.arduino.ArduinoDevice(new InetSocketAddress(cfg.getStringChecked("host", "'host' not set"), cfg.getIntegerChecked("port", "'port' not set")), new ArduinoDeviceListener(){

            public void stateChange(DeviceState deviceState) {
                ArduinoDevice.this.handleStateChange(deviceState);
            }

            public void deviceDisconnected() {
                ArduinoDevice.this.handleDisconnect();
            }

            public void deviceConnected(Map<Integer, Object>[] parameters) {
                ArduinoDevice.this.handleConnect(parameters);
            }

            public void dataChange(Object[] data) {
                ArduinoDevice.this.handleData(data);
            }
        }, false);
        long timeout = cfg.getLong("timeout", 2000L);
        this.device.setTimeout(timeout);
        this.device.setPollTime(cfg.getLong("pollTime", 100L));
        this.device.setPollTimeout(cfg.getLong("pollTimeout", (long)((double)timeout * 0.66)));
        this.device.start();
    }

    private String makeId(String localId) {
        return String.format("%s.%s", this.alias, localId);
    }

    protected void handleStateChange(DeviceState deviceState) {
        this.deviceStateItem.updateData(Variant.valueOf((Object)deviceState.toString()), null, null);
    }

    protected void handleData(Object[] data) {
        int i = 0;
        while (i < data.length) {
            this.items[i].updateData(Variant.valueOf((Object)data[i]), null, null);
            ++i;
        }
    }

    protected void handleConnect(Map<Integer, Object>[] parameters) {
        this.stateItem.updateData(Variant.TRUE, null, null);
        this.createItems(parameters);
    }

    protected void handleDisconnect() {
        this.stateItem.updateData(Variant.FALSE, null, null);
        this.disposeItems();
    }

    private void disposeItems() {
        if (this.items != null) {
            ArduinoDataItem[] arduinoDataItemArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                ArduinoDataItem item = arduinoDataItemArray[n2];
                this.itemPool.removeService(item.getInformation().getName(), (Object)item);
                ++n2;
            }
        }
        this.items = null;
    }

    private void createItems(Map<Integer, Object>[] parameters) {
        this.items = new ArduinoDataItem[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            this.items[i] = new ArduinoDataItem(this.device, (short)i, (DataItemInformation)new DataItemInformationBase(this.makeId(String.format("data.%s", this.getItemName(i, parameters[i]))), this.getIODirection(parameters[i])), this.executor);
            this.itemPool.addService(this.items[i].getInformation().getName(), (Object)this.items[i], null);
            ++i;
        }
    }

    private Set<IODirection> getIODirection(Map<Integer, Object> map) {
        EnumSet<IODirection> result = EnumSet.noneOf(IODirection.class);
        Object o = map.get(1);
        if (o instanceof Number) {
            byte b = ((Number)o).byteValue();
            if ((b & 1) == 1) {
                result.add(IODirection.INPUT);
            }
            if ((b & 2) == 2) {
                result.add(IODirection.OUTPUT);
            }
        }
        return result;
    }

    private Object getItemName(int i, Map<Integer, Object> map) {
        Object o = map.get(2);
        if (o == null) {
            return String.format("unnamed-item-%s", i);
        }
        return o.toString();
    }

    public void dispose() {
        this.disposeItems();
        this.itemPool.removeService(this.stateItem.getInformation().getName(), (Object)this.stateItem);
        this.itemPool.removeService(this.deviceStateItem.getInformation().getName(), (Object)this.deviceStateItem);
        this.device.stop();
    }
}

