/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.injector.monitor;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.filter.EventMatcher;
import org.eclipse.scada.ae.filter.internal.EventMatcherImpl;
import org.eclipse.scada.ae.monitor.common.AbstractConfiguration;
import org.eclipse.scada.ae.monitor.common.AbstractPersistentStateMonitor;
import org.eclipse.scada.ae.monitor.common.AbstractStateMonitor;
import org.eclipse.scada.ae.monitor.common.MessageDecorator;
import org.eclipse.scada.ae.monitor.common.MonitorDecorator;
import org.eclipse.scada.ae.server.injector.monitor.EventMonitor;
import org.eclipse.scada.ae.server.injector.monitor.Messages;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.lang.Pair;
import org.osgi.framework.BundleContext;

public class EventMonitorImpl
extends AbstractPersistentStateMonitor
implements EventMonitor {
    private EventMatcher matcher = null;
    private String monitorType = Messages.getString("EventMonitorImpl.tag.event");
    private Configuration configuration;

    public EventMonitorImpl(BundleContext context, Executor executor, EventProcessor eventProcessor, String id) {
        super(id, "ae.monitor.ae.event.external", executor, context, null, eventProcessor);
    }

    @Override
    public void update(UserInformation userInformation, Map<String, String> properties) {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        this.setStringAttributes(cfg.getPrefixed("info."));
        Configuration c = new Configuration(this.configuration, (AbstractStateMonitor)this);
        c.setActive(userInformation, cfg.getBoolean("active", true));
        c.setRequireAkn(userInformation, cfg.getBoolean("requireAkn", true));
        c.setSeverity(userInformation, (Severity)cfg.getEnum("severity", Severity.class, (Enum)Severity.ALARM));
        c.setSuppressEvents(userInformation, cfg.getBoolean("suppressEvents", false));
        this.setEventMatcher(userInformation, cfg.getString("filter", ""));
        this.setMonitorType(userInformation, cfg.getString("monitorType", Messages.getString("EventMonitorImpl.tag.event")));
        this.configuration = c;
        c.sendEvents();
        this.setSuppressEvents(c.suppressEvents);
        this.setOk(Variant.NULL, System.currentTimeMillis());
    }

    private void setEventMatcher(UserInformation userInformation, String filter) {
        this.matcher = new EventMatcherImpl(filter);
    }

    private void setMonitorType(UserInformation userInformation, String monitorType) {
        this.monitorType = monitorType;
    }

    protected void injectEventAttributes(Event.EventBuilder builder) {
        super.injectEventAttributes(builder);
        builder.attribute(Event.Fields.MONITOR_TYPE, (Object)this.monitorType);
    }

    @Override
    public synchronized Pair<Boolean, Event> evaluate(Event event) {
        if (this.matcher != null && this.matcher.matches(event)) {
            Variant message = this.makeMessage(event);
            this.triggerFailure(Variant.NULL, this.makeLong(event.getSourceTimestamp()), this.configuration.severity, this.configuration.requireAkn, (MonitorDecorator)new MessageDecorator(message));
            Event resultEvent = Event.create().event(event).attribute(Event.Fields.COMMENT, this.annotateCommentWithSource(event)).attribute(Event.Fields.SOURCE, (Object)this.getId()).attribute(Event.Fields.MONITOR_TYPE, (Object)this.monitorType).build();
            return new Pair((Object)true, (Object)resultEvent);
        }
        return new Pair((Object)false, (Object)event);
    }

    private Long makeLong(Date timestamp) {
        if (timestamp == null) {
            return null;
        }
        return timestamp.getTime();
    }

    private Variant makeMessage(Event event) {
        return (Variant)event.getAttributes().get(Event.Fields.MESSAGE.getName());
    }

    private Variant annotateCommentWithSource(Event event) {
        StringBuilder sb = new StringBuilder();
        Variant originalComment = event.getField(Event.Fields.COMMENT);
        Variant originalSource = event.getField(Event.Fields.SOURCE);
        boolean commentThere = false;
        if (originalComment != null && originalComment.isString() && originalComment.asString("").length() > 0) {
            commentThere = true;
            sb.append(originalComment.asString(""));
        }
        if (originalSource != null && originalSource.isString() && originalSource.asString("").length() > 0) {
            if (commentThere) {
                sb.append(Messages.getString("EventMonitorImpl.delimiter"));
            }
            sb.append(Messages.getString("EventMonitorImpl.string.originalSource"));
            sb.append(originalSource.asString(""));
        }
        return Variant.valueOf((Object)sb.toString());
    }

    private static class Configuration
    extends AbstractConfiguration {
        boolean active;
        boolean requireAkn;
        Severity severity;
        boolean suppressEvents;

        public Configuration(Configuration currentConfiguration, AbstractStateMonitor monitor) {
            super((AbstractConfiguration)currentConfiguration, monitor);
            if (currentConfiguration != null) {
                this.severity = currentConfiguration.severity;
                this.active = currentConfiguration.active;
                this.requireAkn = currentConfiguration.requireAkn;
                this.suppressEvents = currentConfiguration.suppressEvents;
            }
        }

        public void setSuppressEvents(UserInformation userInformation, boolean suppressEvents) {
            this.suppressEvents = (Boolean)this.update(userInformation, this.suppressEvents, suppressEvents);
        }

        public void setSeverity(UserInformation userInformation, Severity severity) {
            this.severity = (Severity)this.update(userInformation, this.severity, severity);
        }

        public void setActive(UserInformation userInformation, boolean active) {
            this.active = (Boolean)this.update(userInformation, this.active, active);
        }

        public void setRequireAkn(UserInformation userInformation, boolean requireAkn) {
            this.requireAkn = (Boolean)this.update(userInformation, this.requireAkn, requireAkn);
        }
    }
}

