/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.ngp;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.ae.BrowserListener;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.Query;
import org.eclipse.scada.ae.QueryListener;
import org.eclipse.scada.ae.UnknownQueryException;
import org.eclipse.scada.ae.data.BrowserEntry;
import org.eclipse.scada.ae.data.EventInformation;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.data.QueryState;
import org.eclipse.scada.ae.data.message.AcknowledgeRequest;
import org.eclipse.scada.ae.data.message.AcknowledgeResponse;
import org.eclipse.scada.ae.data.message.BrowseData;
import org.eclipse.scada.ae.data.message.CloseQuery;
import org.eclipse.scada.ae.data.message.CreateQuery;
import org.eclipse.scada.ae.data.message.EventPoolDataUpdate;
import org.eclipse.scada.ae.data.message.EventPoolStatusUpdate;
import org.eclipse.scada.ae.data.message.LoadMore;
import org.eclipse.scada.ae.data.message.MonitorPoolDataUpdate;
import org.eclipse.scada.ae.data.message.MonitorPoolStatusUpdate;
import org.eclipse.scada.ae.data.message.StartBrowse;
import org.eclipse.scada.ae.data.message.StopBrowse;
import org.eclipse.scada.ae.data.message.SubscribeEventPool;
import org.eclipse.scada.ae.data.message.SubscribeMonitorPool;
import org.eclipse.scada.ae.data.message.UnsubscribeEventPool;
import org.eclipse.scada.ae.data.message.UnsubscribeMonitorPool;
import org.eclipse.scada.ae.data.message.UpdateQueryData;
import org.eclipse.scada.ae.data.message.UpdateQueryState;
import org.eclipse.scada.ae.server.EventListener;
import org.eclipse.scada.ae.server.MonitorListener;
import org.eclipse.scada.ae.server.Service;
import org.eclipse.scada.ae.server.Session;
import org.eclipse.scada.ae.server.ngp.BrowserListenerManager;
import org.eclipse.scada.ae.server.ngp.QueryImpl;
import org.eclipse.scada.core.InvalidSessionException;
import org.eclipse.scada.core.data.ErrorInformation;
import org.eclipse.scada.core.data.Response;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.server.ngp.ServiceServerConnection;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectionImpl
extends ServiceServerConnection<Session, Service> {
    private static final Logger logger = LoggerFactory.getLogger(ServerConnectionImpl.class);
    private BrowserListenerManager browserListenerManager;
    private final Map<Long, QueryImpl> queries = new HashMap<Long, QueryImpl>();

    public ServerConnectionImpl(IoSession session, Service service) {
        super(session, (org.eclipse.scada.core.server.Service)service);
    }

    public void dispose() {
        for (QueryImpl query : this.queries.values()) {
            query.close();
        }
        this.queries.clear();
        super.dispose();
    }

    protected void initializeSession(Session session) {
        super.initializeSession((org.eclipse.scada.core.server.Session)session);
        session.setMonitorListener(new MonitorListener(){

            public void dataChanged(String subscriptionId, List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
                ServerConnectionImpl.this.handleMonitorDataChanged(subscriptionId, addedOrUpdated, removed, full);
            }

            public void updateStatus(String topic, SubscriptionState subscriptionState) {
                ServerConnectionImpl.this.handleMonitorStatusChange(topic.toString(), subscriptionState);
            }
        });
        session.setEventListener(new EventListener(){

            public void dataChanged(String poolId, List<Event> addedEvents) {
                ServerConnectionImpl.this.handleEventDataChange(poolId, addedEvents);
            }

            public void updateStatus(String topic, SubscriptionState subscriptionState) {
                ServerConnectionImpl.this.handleEventStatusChange(topic.toString(), subscriptionState);
            }
        });
    }

    protected void handleEventDataChange(String eventPoolId, List<Event> addedEvents) {
        this.sendMessage(new EventPoolDataUpdate(eventPoolId, this.convert(addedEvents)));
    }

    protected void handleMonitorDataChanged(String monitorPoolId, List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
        this.sendMessage(new MonitorPoolDataUpdate(monitorPoolId, addedOrUpdated, removed, full));
    }

    protected void handleEventStatusChange(String eventPoolId, SubscriptionState state) {
        this.sendMessage(new EventPoolStatusUpdate(eventPoolId, state));
    }

    protected void handleMonitorStatusChange(String monitorPoolId, SubscriptionState state) {
        this.sendMessage(new MonitorPoolStatusUpdate(monitorPoolId, state));
    }

    public void messageReceived(Object message) throws Exception {
        logger.trace("Received message: {}", message);
        if (message instanceof StartBrowse) {
            this.handleStartBrowse();
        } else if (message instanceof StopBrowse) {
            this.handleStopBrowse();
        } else if (message instanceof SubscribeMonitorPool) {
            this.handleSubscribeMonitorPool((SubscribeMonitorPool)message);
        } else if (message instanceof UnsubscribeMonitorPool) {
            this.handleUnsubscribeMonitorPool((UnsubscribeMonitorPool)message);
        } else if (message instanceof SubscribeEventPool) {
            this.handleSubscribeEventPool((SubscribeEventPool)message);
        } else if (message instanceof UnsubscribeEventPool) {
            this.handleUnsubscribeEventPool((UnsubscribeEventPool)message);
        } else if (message instanceof CloseQuery) {
            this.handleCloseQuery((CloseQuery)message);
        } else if (message instanceof CreateQuery) {
            this.handleCreateQuery((CreateQuery)message);
        } else if (message instanceof LoadMore) {
            this.handleLoadMore((LoadMore)message);
        } else if (message instanceof AcknowledgeRequest) {
            this.handleAknRequest((AcknowledgeRequest)message);
        } else {
            super.messageReceived(message);
        }
    }

    private void handleAknRequest(final AcknowledgeRequest message) throws InvalidSessionException {
        Date timestamp = message.getAknTimestamp() == null ? null : new Date(message.getAknTimestamp());
        CallbackHandler callbackHandler = this.createCallbackHandler(message.getCallbackHandlerId());
        NotifyFuture future = ((Service)this.service).acknowledge((Session)this.session, message.getMonitorId(), timestamp, message.getOperationParameters(), callbackHandler);
        future.addListener((FutureListener)new FutureListener<Void>(){

            public void complete(Future<Void> future) {
                try {
                    future.get();
                    ServerConnectionImpl.this.sendMessage(new AcknowledgeResponse(new Response(message.getRequest()), null));
                }
                catch (Exception e) {
                    ServerConnectionImpl.this.sendMessage(new AcknowledgeResponse(new Response(message.getRequest()), new ErrorInformation(Long.valueOf(1L), "Permission denied", ExceptionHelper.formatted((Throwable)e))));
                }
            }
        });
    }

    private void handleCreateQuery(CreateQuery message) throws InvalidSessionException {
        long queryId = message.getQueryId();
        if (this.queries.containsKey(queryId)) {
            throw new IllegalStateException(String.format("Query Id %s already exists", queryId));
        }
        QueryImpl query = new QueryImpl(queryId, this);
        Query queryHandle = ((Service)this.service).createQuery((Session)this.session, message.getQueryType(), message.getQueryData(), (QueryListener)query);
        query.setQuery(queryHandle);
        this.queries.put(queryId, query);
    }

    private void handleLoadMore(LoadMore message) {
        QueryImpl query = this.queries.get(message.getQueryId());
        if (query == null) {
            return;
        }
        query.loadMore(message.getCount());
    }

    private void handleCloseQuery(CloseQuery message) {
        QueryImpl query = this.queries.get(message.getQueryId());
        if (query == null) {
            return;
        }
        query.close();
    }

    private void handleSubscribeMonitorPool(SubscribeMonitorPool message) throws Exception {
        try {
            ((Service)this.service).subscribeConditionQuery((Session)this.session, message.getMonitorPoolId());
        }
        catch (UnknownQueryException e) {
            logger.warn("Subscribe to unknwn query", (Throwable)e);
        }
    }

    private void handleUnsubscribeMonitorPool(UnsubscribeMonitorPool message) throws Exception {
        ((Service)this.service).unsubscribeConditionQuery((Session)this.session, message.getMonitorPoolId());
    }

    private void handleSubscribeEventPool(SubscribeEventPool message) throws Exception {
        try {
            ((Service)this.service).subscribeEventQuery((Session)this.session, message.getEventPoolId());
        }
        catch (UnknownQueryException e) {
            logger.warn("Subscribe to unknwn query", (Throwable)e);
        }
    }

    private void handleUnsubscribeEventPool(UnsubscribeEventPool message) throws Exception {
        ((Service)this.service).unsubscribeEventQuery((Session)this.session, message.getEventPoolId());
    }

    private void handleStopBrowse() {
        if (this.browserListenerManager == null) {
            return;
        }
        ((Session)this.session).setBrowserListener(null);
        this.browserListenerManager = null;
    }

    private void handleStartBrowse() {
        if (this.browserListenerManager != null) {
            return;
        }
        this.browserListenerManager = new BrowserListenerManager(this);
        ((Session)this.session).setBrowserListener((BrowserListener)this.browserListenerManager);
    }

    public synchronized void sendQueryData(QueryImpl queryImpl, List<Event> events) {
        QueryImpl query = this.queries.get(queryImpl.getQueryId());
        if (query == null) {
            return;
        }
        this.sendMessage(new UpdateQueryData(query.getQueryId(), this.convert(events)));
    }

    public synchronized void sendQueryState(QueryImpl queryImpl, QueryState state, Throwable error) {
        QueryImpl query = this.queries.get(queryImpl.getQueryId());
        if (query == null) {
            return;
        }
        this.sendMessage(new UpdateQueryState(query.getQueryId(), state, new ErrorInformation(null, error == null ? null : error.getMessage(), ExceptionHelper.formatted((Throwable)error))));
    }

    private List<EventInformation> convert(List<Event> events) {
        ArrayList<EventInformation> result = new ArrayList<EventInformation>(events.size());
        for (Event event : events) {
            result.add(this.convertEvent(event));
        }
        return result;
    }

    private EventInformation convertEvent(Event event) {
        return new EventInformation(event.getId().toString(), event.getSourceTimestamp().getTime(), event.getEntryTimestamp().getTime(), event.getAttributes());
    }

    public synchronized void handleBrowseDataChanged(BrowserListenerManager browserListenerManager, List<BrowserEntry> addedOrUpdated, Set<String> removed, boolean full) {
        if (this.browserListenerManager != browserListenerManager) {
            return;
        }
        this.sendMessage(new BrowseData(addedOrUpdated, removed, full));
    }
}

