/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.simulation.component;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.browser.common.query.AttributeNameProvider;
import org.eclipse.scada.da.server.browser.common.query.GroupFolder;
import org.eclipse.scada.da.server.browser.common.query.GroupProvider;
import org.eclipse.scada.da.server.browser.common.query.IDNameProvider;
import org.eclipse.scada.da.server.browser.common.query.InvisibleStorage;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.browser.common.query.ItemStorage;
import org.eclipse.scada.da.server.browser.common.query.Matcher;
import org.eclipse.scada.da.server.browser.common.query.NameProvider;
import org.eclipse.scada.da.server.browser.common.query.QueryFolder;
import org.eclipse.scada.da.server.browser.common.query.SplitGroupProvider;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.simulation.component.modules.BaseModule;
import org.eclipse.scada.da.server.simulation.component.modules.SimpleMOV;
import org.eclipse.scada.da.server.simulation.component.modules.SimpleScale;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;

public class Hive
extends HiveCommon {
    private final ScheduledExecutorService executor;
    private final List<BaseModule> modules = new LinkedList<BaseModule>();
    private final InvisibleStorage storage = new InvisibleStorage();

    public Hive() {
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("org.eclipse.scada.da.server.simulation.component"));
        FolderCommon rootFolder = new FolderCommon();
        this.setRootFolder((Folder)rootFolder);
        QueryFolder queryFolder = new QueryFolder(new Matcher(){

            public boolean matches(ItemDescriptor desc) {
                return true;
            }
        }, (NameProvider)new IDNameProvider());
        rootFolder.add("all", (Folder)queryFolder, new HashMap());
        this.storage.addChild((ItemStorage)queryFolder);
        GroupFolder groupFolder = new GroupFolder((GroupProvider)new SplitGroupProvider((NameProvider)new AttributeNameProvider("tag"), "\\."), (NameProvider)new IDNameProvider());
        rootFolder.add("components", (Folder)groupFolder, new HashMap());
        this.storage.addChild((ItemStorage)groupFolder);
    }

    public String getHiveId() {
        return "org.eclipse.scada.da.server.simulation.component";
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    protected void performStart() throws Exception {
        super.performStart();
        this.addModule(new SimpleMOV(this, "1000"));
        this.addModule(new SimpleScale(this, "1001"));
    }

    protected void performStop() throws Exception {
        for (BaseModule module : this.modules) {
            module.dispose();
        }
        this.modules.clear();
        this.executor.shutdown();
        super.performStop();
    }

    public ItemStorage getStorage() {
        return this.storage;
    }

    public void addModule(BaseModule module) {
        this.modules.add(module);
    }
}

