/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.client.net;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.client.net.ConnectionImpl;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
implements Query {
    private static final Logger logger = LoggerFactory.getLogger(QueryImpl.class);
    private final Executor executor;
    private final String itemId;
    private QueryParameters parameters;
    private QueryListener listener;
    private final ConnectionImpl connection;
    private boolean closed = false;
    private Long id;
    private Long closeId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryImpl(Executor executor, ConnectionImpl connection, String itemId, QueryParameters parameters, QueryListener listener) {
        this.executor = executor;
        this.connection = connection;
        this.itemId = itemId;
        this.parameters = parameters;
        this.listener = listener;
        QueryImpl queryImpl = this;
        synchronized (queryImpl) {
            this.fireStateChange(listener, QueryState.REQUESTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        QueryImpl queryImpl = this;
        synchronized (queryImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            logger.info("Closing query: {} ({})", new Object[]{this.itemId, this.parameters});
            this.fireStateChange(this.listener, QueryState.DISCONNECTED);
            this.listener = null;
            this.closeId = this.id;
            this.id = null;
        }
        this.connection.closeQuery(this);
    }

    private void fireStateChange(final QueryListener listener, final QueryState state) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                listener.updateState(state);
            }
        });
    }

    private void fireParameterChange(final QueryListener listener, final QueryParameters parameters, final Set<String> valueTypes) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                listener.updateParameters(parameters, valueTypes);
            }
        });
    }

    private void fireDataChange(QueryListener listener, final int index, final Map<String, List<Double>> values, final List<ValueInformation> valueInformation) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                logger.debug("Data update: {} (v: {}, vi: {})", new Object[]{index, values.size(), valueInformation.size()});
                QueryImpl.this.listener.updateData(index, values, valueInformation);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeParameters(QueryParameters parameters) {
        QueryImpl queryImpl = this;
        synchronized (queryImpl) {
            if (this.closed) {
                return;
            }
            if (this.parameters == parameters) {
                return;
            }
            this.parameters = parameters;
        }
        this.connection.updateQueryParameters(this, parameters);
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public Long getCloseId() {
        return this.closeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpdateStatus(QueryState state) {
        QueryImpl queryImpl = this;
        synchronized (queryImpl) {
            if (this.closed) {
                return;
            }
            this.fireStateChange(this.listener, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpdateData(int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
        QueryImpl queryImpl = this;
        synchronized (queryImpl) {
            if (this.closed) {
                return;
            }
            this.fireDataChange(this.listener, index, values, valueInformation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpdateParameter(QueryParameters parameters, Set<String> valueTypes) {
        QueryImpl queryImpl = this;
        synchronized (queryImpl) {
            if (this.closed) {
                return;
            }
            this.fireParameterChange(this.listener, parameters, valueTypes);
        }
    }
}

