/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.script;

import com.google.common.collect.Interner;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.common.AbstractPersistentStateMonitor;
import org.eclipse.scada.ae.monitor.common.DemoteImpl;
import org.eclipse.scada.ae.monitor.common.PersistentInformation;
import org.eclipse.scada.ae.monitor.datasource.MonitorStateInjector;
import org.eclipse.scada.ae.monitor.script.MultiMasterHandler;
import org.eclipse.scada.ae.monitor.script.ScriptMonitorResult;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceHandler;
import org.eclipse.scada.da.datasource.MultiDataSourceListener;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.eclipse.scada.utils.script.ScriptExecutor;
import org.eclipse.scada.utils.script.Scripts;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptMonitor
extends AbstractPersistentStateMonitor {
    private static final Logger logger = LoggerFactory.getLogger(ScriptMonitor.class);
    private static final String DEFAULT_ENGINE_NAME = "JavaScript";
    private final InjectMasterHandler handler;
    private final DemoteImpl demoteImpl = new DemoteImpl();
    private final MultiDataSourceListener listener;
    private final MonitorStateInjector monitorStateInjector;
    private final ClassLoader classLoader;
    private SimpleScriptContext scriptContext;
    private ScriptExecutor updateCommand;
    private final ScriptMonitorResult lastResult = new ScriptMonitorResult();
    private final String prefix;
    private final Executor executor;

    public ScriptMonitor(String id, String factoryId, Executor executor, BundleContext context, Interner<String> stringInterner, EventProcessor eventProcessor, ObjectPoolTracker<DataSource> dataSourcePoolTracker, ObjectPoolTracker<MasterItem> masterItemPoolTracker, ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> caTracker) {
        super(id, factoryId, executor, context, stringInterner, eventProcessor);
        this.executor = executor;
        this.prefix = (String)stringInterner.intern((Object)(String.valueOf(factoryId) + ". " + id));
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.monitorStateInjector = new MonitorStateInjector(stringInterner);
        this.monitorStateInjector.setPrefix(this.prefix);
        this.handler = new InjectMasterHandler(id, masterItemPoolTracker, 0, caTracker, this.prefix, factoryId);
        this.listener = new MultiDataSourceListener(dataSourcePoolTracker){

            protected void handleChange(Map<String, DataSourceHandler> sources) {
                ScriptMonitor.this.handleChange(sources);
            }
        };
    }

    public void dispose() {
        this.handler.dispose();
        this.listener.dispose();
        super.dispose();
    }

    protected synchronized void notifyStateChange(MonitorStatusInformation state) {
        super.notifyStateChange(state);
        this.monitorStateInjector.notifyStateChange(state);
        this.handler.reprocess();
    }

    protected synchronized void applyPersistentInformation(PersistentInformation persistentInformation) {
        super.applyPersistentInformation(persistentInformation);
        this.handleChange(this.listener.getSourcesCopy());
    }

    public void update(UserInformation userInformation, Map<String, String> properties) throws Exception {
        logger.info("Changing configuration - {}", properties);
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        this.setScript(cfg);
        this.demoteImpl.update(userInformation, properties);
        this.handler.update(userInformation, properties);
        this.listener.setDataSources(properties);
        this.setSuppressEvents(cfg.getBoolean("suppressEvents", false));
        this.setStringAttributes(cfg.getPrefixed("info."));
        this.handleChange(this.listener.getSourcesCopy());
    }

    private synchronized void setScript(ConfigurationDataHelper cfg) throws Exception {
        String engineName = cfg.getString("scriptEngine", DEFAULT_ENGINE_NAME);
        if ("".equals(engineName)) {
            engineName = DEFAULT_ENGINE_NAME;
        }
        ScriptEngine engine = Scripts.createEngine((String)engineName, (ClassLoader)this.classLoader);
        this.scriptContext = new SimpleScriptContext();
        String initScript = cfg.getString("init");
        if (initScript != null) {
            new ScriptExecutor(engine, initScript, this.classLoader).execute((ScriptContext)this.scriptContext);
        }
        this.updateCommand = this.makeScript(engine, cfg.getString("updateCommand"));
    }

    private ScriptExecutor makeScript(ScriptEngine engine, String string) throws Exception {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return new ScriptExecutor(engine, string, this.classLoader);
    }

    public synchronized DataItemValue dataUpdate(Map<String, Object> context, DataItemValue.Builder builder) {
        this.demoteImpl.handleDataUpdate(context, builder);
        this.monitorStateInjector.injectAttributes(builder);
        return builder.build();
    }

    protected void handleChange(Map<String, DataSourceHandler> sources) {
        final HashMap<String, DataItemValue> values = new HashMap<String, DataItemValue>(sources.size());
        for (Map.Entry<String, DataSourceHandler> entry : sources.entrySet()) {
            values.put(entry.getKey(), entry.getValue().getValue());
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ScriptMonitor.this.evaluate(values);
            }
        });
    }

    protected synchronized void evaluate(Map<String, DataItemValue> values) {
        this.applyState(this.evaluateState(values));
    }

    private synchronized void applyState(ScriptMonitorResult evaluateState) {
        logger.debug("Apply state: {}", (Object)evaluateState);
        switch (evaluateState.monitorStatus) {
            case UNSAFE: {
                this.setUnsafe();
                break;
            }
            case OK: {
                this.setOk(evaluateState.value, evaluateState.valueTimestamp);
                break;
            }
            case FAILURE: {
                this.setFailure(evaluateState.value, evaluateState.valueTimestamp, evaluateState.severity, evaluateState.requireAck == null ? true : evaluateState.requireAck);
                break;
            }
            case INACTIVE: {
                this.setInactive();
            }
        }
    }

    private ScriptMonitorResult evaluateState(Map<String, DataItemValue> values) {
        HashMap<String, Object> scriptObjects = new HashMap<String, Object>();
        scriptObjects.put("values", values);
        scriptObjects.put("UNSAFE", ScriptMonitorResult.UNSAFE);
        scriptObjects.put("INACTIVE", ScriptMonitorResult.INACTIVE);
        scriptObjects.put("OK", ScriptMonitorResult.OkBuilder.INSTANCE);
        scriptObjects.put("FAILURE", ScriptMonitorResult.FailureBuilder.INSTANCE);
        scriptObjects.put("result", this.lastResult);
        try {
            logger.debug("Running update command - values: {}", values);
            return this.convertState(this.updateCommand.execute((ScriptContext)this.scriptContext, scriptObjects));
        }
        catch (Exception e) {
            logger.warn("Failed to evaluate monitor", (Throwable)e);
            return ScriptMonitorResult.UNSAFE;
        }
    }

    private ScriptMonitorResult convertState(Object execute) {
        logger.debug("Converting: {}", execute);
        if (execute == null) {
            return ScriptMonitorResult.UNSAFE;
        }
        if (execute instanceof ScriptMonitorResult) {
            return (ScriptMonitorResult)execute;
        }
        return ScriptMonitorResult.UNSAFE;
    }

    protected void setFailure(Variant value, Long valueTimestamp, Severity severity, boolean requireAck) {
        Severity result = this.demoteImpl.demoteSeverity(severity);
        if (result == null) {
            this.setOk(value, valueTimestamp);
        } else {
            super.setFailure(value, valueTimestamp, result, this.demoteImpl.demoteAck(requireAck));
        }
    }

    public class InjectMasterHandler
    extends MultiMasterHandler {
        public InjectMasterHandler(String configurationId, ObjectPoolTracker<MasterItem> poolTracker, int priority, ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> caTracker, String prefix, String factoryId) {
            super(configurationId, poolTracker, priority, caTracker, prefix, factoryId);
        }

        public void dataUpdate(Map<String, Object> context, DataItemValue.Builder value) {
            ScriptMonitor.this.dataUpdate(context, value);
        }

        protected WriteAttributeResults handleUpdate(Map<String, Variant> attributes, OperationParameters operationParameters) throws Exception {
            return null;
        }

        protected void reprocess() {
            super.reprocess();
        }
    }
}

