/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.datasource.common.internal;

import com.google.common.collect.Interner;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.MonitorService;
import org.eclipse.scada.ae.monitor.datasource.AbstractMonitorFactory;
import org.eclipse.scada.ae.monitor.datasource.common.bit.BitMonitorFactory;
import org.eclipse.scada.ae.monitor.datasource.common.level.LevelMonitorFactory;
import org.eclipse.scada.ae.monitor.datasource.common.list.ListMonitorFactory;
import org.eclipse.scada.ae.monitor.datasource.common.remote.RemoteAttributeMonitorFactoryImpl;
import org.eclipse.scada.ae.monitor.datasource.common.remote.RemoteValueMonitorFactoryImpl;
import org.eclipse.scada.ae.server.common.akn.AknHandler;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.eclipse.scada.utils.interner.InternerHelper;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private Interner<String> stringInterner;
    private EventProcessor eventProcessor;
    private ExportedExecutorService executor;
    private ObjectPoolTracker<MasterItem> poolTracker;
    private ObjectPoolImpl<MonitorService> monitorServicePool;
    private ServiceRegistration<?> monitorServicePoolHandler;
    private final List<AbstractMonitorFactory> factories = new LinkedList<AbstractMonitorFactory>();

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.stringInterner = InternerHelper.makeInterner((String)"org.eclipse.scada.ae.monitor.datasource.common.stringInternerType", (String)"strong");
        this.eventProcessor = new EventProcessor(context);
        this.eventProcessor.open();
        this.executor = new ExportedExecutorService(bundleContext.getBundle().getSymbolicName(), 1, 1, 1L, TimeUnit.MINUTES);
        this.poolTracker = new ObjectPoolTracker(context, MasterItem.class);
        this.poolTracker.open();
        this.monitorServicePool = new ObjectPoolImpl();
        this.monitorServicePoolHandler = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.monitorServicePool, MonitorService.class);
        AbstractMonitorFactory factory = new LevelMonitorFactory(bundleContext, (ManageableObjectPool<MonitorService>)this.monitorServicePool, this.eventProcessor, (Executor)this.executor, this.stringInterner, this.poolTracker);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("factoryId", "org.eclipse.scada.ae.monitor.level");
        properties.put("service.description", "Level monitor");
        context.registerService(new String[]{ConfigurationFactory.class.getName(), AknHandler.class.getName()}, (Object)factory, properties);
        this.factories.add(factory);
        factory = new BitMonitorFactory(bundleContext, (ManageableObjectPool<MonitorService>)this.monitorServicePool, this.eventProcessor, (Executor)this.executor, this.stringInterner, this.poolTracker);
        properties = new Hashtable();
        properties.put("factoryId", "org.eclipse.scada.ae.monitor.bit");
        properties.put("service.description", "Boolean monitor");
        context.registerService(new String[]{ConfigurationFactory.class.getName(), AknHandler.class.getName()}, (Object)factory, properties);
        this.factories.add(factory);
        factory = new ListMonitorFactory(bundleContext, (ManageableObjectPool<MonitorService>)this.monitorServicePool, this.eventProcessor, (Executor)this.executor, this.stringInterner, this.poolTracker);
        properties = new Hashtable();
        properties.put("factoryId", "org.eclipse.scada.ae.monitor.list");
        properties.put("service.description", "List monitor");
        context.registerService(new String[]{ConfigurationFactory.class.getName(), AknHandler.class.getName()}, (Object)factory, properties);
        this.factories.add(factory);
        factory = new RemoteAttributeMonitorFactoryImpl(context, (ManageableObjectPool<MonitorService>)this.monitorServicePool, (Executor)this.executor, this.poolTracker, this.eventProcessor);
        properties = new Hashtable();
        properties.put("factoryId", "ae.monitor.da.remote.booleanAttributeAlarm");
        properties.put("service.description", "Remote Boolean attribute alarms");
        context.registerService(new String[]{ConfigurationFactory.class.getName(), AknHandler.class.getName()}, (Object)factory, properties);
        this.factories.add(factory);
        factory = new RemoteValueMonitorFactoryImpl(context, (ManageableObjectPool<MonitorService>)this.monitorServicePool, (Executor)this.executor, this.poolTracker, this.eventProcessor);
        properties = new Hashtable();
        properties.put("factoryId", "ae.monitor.da.remote.booleanValueAlarm");
        properties.put("service.description", "Remote Boolean value alarms");
        context.registerService(new String[]{ConfigurationFactory.class.getName(), AknHandler.class.getName()}, (Object)factory, properties);
        this.factories.add(factory);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        for (AbstractMonitorFactory factory : this.factories) {
            factory.dispose();
        }
        this.factories.clear();
        this.monitorServicePoolHandler.unregister();
        this.monitorServicePool.dispose();
        this.poolTracker.close();
        this.eventProcessor.close();
        this.executor.shutdown();
        context = null;
    }
}

