/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.component.parser.factory.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.base.extractor.extract.Extractor;
import org.eclipse.scada.base.extractor.input.Input;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.component.Hive;
import org.eclipse.scada.da.server.component.parser.ParserComponent;
import org.eclipse.scada.da.server.component.parser.factory.CreationContext;
import org.eclipse.scada.da.server.component.parser.factory.configuration.Component;
import org.eclipse.scada.da.server.component.parser.factory.configuration.ExtractorDefinition;

public class ComponentImpl
extends ParserComponent {
    private final Input input;

    public ComponentImpl(final ScheduledExecutorService executor, Hive hive, FolderCommon folder, Component component) {
        super((Executor)executor, hive, folder, component.getId());
        CreationContext creationContext = new CreationContext(){

            @Override
            public ScheduledExecutorService getExecutor() {
                return executor;
            }
        };
        this.input = component.getInput().createInput(creationContext);
        for (ExtractorDefinition extractorDef : component.getExtractors()) {
            Extractor extractor = extractorDef.createExtractor(creationContext);
            this.bindInput(this.input, extractor, extractorDef.getPrefix());
        }
    }

    public void dispose() {
        if (this.input != null) {
            this.input.dispose();
        }
        super.dispose();
    }
}

