/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.sfp.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.FolderListener;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.core.browser.DataItemEntry;
import org.eclipse.scada.da.data.IODirection;

public class Folder {
    private final Folder parent;
    private FolderListener listener;
    private final Executor executor;
    private final Location location;
    private final Map<String, Entry> entries = new HashMap<String, Entry>();

    public Folder(Executor executor, Folder parent, Location location) {
        this.executor = executor;
        this.parent = parent;
        this.location = location;
    }

    public void setListener(FolderListener listener) {
        this.listener = listener;
        if (listener != null && !this.entries.isEmpty()) {
            ArrayList<org.eclipse.scada.da.core.browser.Entry> added = new ArrayList<org.eclipse.scada.da.core.browser.Entry>(this.entries.size());
            for (Map.Entry<String, Entry> entry : this.entries.entrySet()) {
                added.add(entry.getValue());
            }
            this.fireListener(added, null, true);
        }
    }

    public void dispose() {
        for (Map.Entry<String, Entry> entry : this.entries.entrySet()) {
            if (!(entry.getValue() instanceof FolderEntry)) continue;
            ((FolderEntry)entry.getValue()).getFolder().dispose();
        }
        this.fireListener(null, null, true);
        this.entries.clear();
    }

    protected void fireListener(final Collection<org.eclipse.scada.da.core.browser.Entry> added, final Collection<String> removed, final boolean full) {
        final FolderListener listener = this.listener;
        if (listener == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                listener.folderChanged(added == null ? Collections.emptyList() : added, removed == null ? Collections.emptyList() : removed, full);
            }
        });
    }

    public Folder findFolder(Stack<String> path, boolean create) {
        if (path.isEmpty()) {
            return this;
        }
        String name = path.pop();
        Entry entry = this.entries.get(name);
        if (entry instanceof FolderEntry) {
            return ((FolderEntry)entry).getFolder().findFolder(path, create);
        }
        if (entry == null && create) {
            Folder folder = new Folder(this.executor, this, new Location(this.location, name));
            FolderEntry folderEntry = new FolderEntry(name, folder);
            this.entries.put(name, folderEntry);
            this.fireListener(Arrays.asList(folderEntry), null, false);
            return folder.findFolder(path, create);
        }
        return null;
    }

    public void addItemEntry(String name, String itemId, String description) {
        ItemEntry entry = new ItemEntry(name, itemId, description);
        this.entries.put(name, entry);
        this.fireListener(Arrays.asList(entry), null, false);
    }

    public void removeItemEntry(String name) {
        if (this.entries.remove(name) != null) {
            this.fireListener(null, Arrays.asList(name), false);
            this.propagateEmpty();
        }
    }

    private void propagateEmpty() {
        if (this.parent != null && this.entries.isEmpty()) {
            this.parent.removeFolderEntry(this);
        }
    }

    protected void removeFolderEntry(Folder folder) {
        boolean removed = false;
        Iterator<Map.Entry<String, Entry>> i = this.entries.entrySet().iterator();
        while (i.hasNext()) {
            Folder childFolder;
            Map.Entry<String, Entry> entry = i.next();
            if (!(entry.getValue() instanceof FolderEntry) || (childFolder = ((FolderEntry)entry.getValue()).getFolder()) != folder) continue;
            i.remove();
            this.fireListener(null, Arrays.asList(entry.getKey()), false);
            removed = true;
        }
        if (removed) {
            this.propagateEmpty();
        }
    }

    private static abstract class Entry
    implements org.eclipse.scada.da.core.browser.Entry {
        private final String name;

        public Entry(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class FolderEntry
    extends Entry
    implements org.eclipse.scada.da.core.browser.FolderEntry {
        private final Folder folder;

        public FolderEntry(String name, Folder folder) {
            super(name);
            this.folder = folder;
        }

        public Folder getFolder() {
            return this.folder;
        }

        public Map<String, Variant> getAttributes() {
            return Collections.emptyMap();
        }
    }

    private static class ItemEntry
    extends Entry
    implements DataItemEntry {
        private final String itemId;
        private final HashMap<String, Variant> attributes;

        public ItemEntry(String name, String itemId, String description) {
            super(name);
            this.itemId = itemId;
            this.attributes = new HashMap(1);
            if (description != null) {
                this.attributes.put("description", Variant.valueOf((Object)description));
            }
        }

        public Map<String, Variant> getAttributes() {
            return this.attributes;
        }

        public String getId() {
            return this.itemId;
        }

        public Set<IODirection> getIODirections() {
            return EnumSet.allOf(IODirection.class);
        }
    }
}

