/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.slave.hds;

import java.io.File;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scada.hd.server.common.HistoricalItem;
import org.eclipse.scada.hd.server.storage.hds.AbstractStorageImpl;
import org.eclipse.scada.hds.DataFilePool;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageImpl
extends AbstractStorageImpl {
    private static final Logger logger = LoggerFactory.getLogger(StorageImpl.class);
    private final ServiceRegistration<HistoricalItem> handle;
    private final Pattern fileNamePattern = Pattern.compile("([0-9a-zA-Z]+)\\.hds");

    public StorageImpl(BundleContext context, File file, DataFilePool pool, ScheduledExecutorService queryExecutor, ScheduledExecutorService eventExecutor) throws Exception {
        super(file, pool, queryExecutor, eventExecutor);
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("service.pid", this.id);
        this.handle = context.registerService(HistoricalItem.class, (Object)this, properties);
    }

    public void dispose() {
        this.handle.unregister();
        super.dispose();
    }

    public void fileDeleted(File file) {
        logger.info("File changed: {}", (Object)file);
        Matcher m = this.fileNamePattern.matcher(file.getName());
        if (!m.matches()) {
            logger.info("Filename did not match pattern");
            return;
        }
        long start = Long.parseLong(m.group(1), 16);
        long slice = this.getStorageInformation().getConfiguration().getTimeSlice();
        logger.info("File change {} to {}", (Object)start, (Object)(start + slice));
        this.handleStoreChanged(new Date(start), new Date(start + slice));
    }

    public void fileChanged(File file) {
        this.fileDeleted(file);
    }
}

