/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.net;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.ae.BrowserListener;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.Query;
import org.eclipse.scada.ae.QueryListener;
import org.eclipse.scada.ae.UnknownQueryException;
import org.eclipse.scada.ae.data.BrowserEntry;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.data.QueryState;
import org.eclipse.scada.ae.net.BrowserMessageHelper;
import org.eclipse.scada.ae.net.EventMessageHelper;
import org.eclipse.scada.ae.net.MonitorMessageHelper;
import org.eclipse.scada.ae.server.EventListener;
import org.eclipse.scada.ae.server.MonitorListener;
import org.eclipse.scada.ae.server.Service;
import org.eclipse.scada.ae.server.Session;
import org.eclipse.scada.ae.server.net.QueryImpl;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.InvalidSessionException;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.data.UserInformation;
import org.eclipse.scada.core.net.MessageHelper;
import org.eclipse.scada.core.server.Session;
import org.eclipse.scada.core.server.net.AbstractServerConnectionHandler;
import org.eclipse.scada.net.base.MessageListener;
import org.eclipse.scada.net.base.data.IntegerValue;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.base.data.VoidValue;
import org.eclipse.scada.net.utils.MessageCreator;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.PropertiesCredentialsCallback;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.concurrent.task.DefaultTaskHandler;
import org.eclipse.scada.utils.concurrent.task.ResultFutureHandler;
import org.eclipse.scada.utils.concurrent.task.ResultHandler;
import org.eclipse.scada.utils.concurrent.task.TaskHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectionHandler
extends AbstractServerConnectionHandler
implements BrowserListener {
    private static final String MESSAGE_QUERY_ID = "queryId";
    public static final String VERSION = "0.1.0";
    private static final Logger logger = LoggerFactory.getLogger(ServerConnectionHandler.class);
    private final Service service;
    private Session session;
    private final TaskHandler taskHandler = new DefaultTaskHandler();
    private final Set<Long> taskMap = new HashSet<Long>();
    private EventListener eventListener;
    private MonitorListener monitorListener;
    private final Map<Long, QueryImpl> queries = new HashMap<Long, QueryImpl>();

    public ServerConnectionHandler(Service service, IoSession ioSession, ConnectionInformation connectionInformation) {
        super(ioSession, connectionInformation);
        this.service = service;
        this.messenger.setHandler(65537, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.createSession(message);
            }
        });
        this.messenger.setHandler(65538, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.closeSession();
            }
        });
        this.messenger.setHandler(196609, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ServerConnectionHandler.this.subscribeEventPool(message);
            }
        });
        this.messenger.setHandler(196610, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ServerConnectionHandler.this.unsubscribeEventPool(message);
            }
        });
        this.messenger.setHandler(196625, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ServerConnectionHandler.this.subscribeMonitors(message);
            }
        });
        this.messenger.setHandler(196626, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ServerConnectionHandler.this.unsubscribeMonitors(message);
            }
        });
        this.messenger.setHandler(196629, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ServerConnectionHandler.this.acknowledge(message);
            }
        });
        this.messenger.setHandler(196657, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ServerConnectionHandler.this.queryCreate(message);
            }
        });
        this.messenger.setHandler(196658, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ServerConnectionHandler.this.queryClose(message);
            }
        });
        this.messenger.setHandler(196661, new MessageListener(){

            public void messageReceived(Message message) throws Exception {
                ServerConnectionHandler.this.queryLoadMore(message);
            }
        });
    }

    private Long queryIdFromMessage(Message message) {
        Long queryId = null;
        Value value = message.getValues().get(MESSAGE_QUERY_ID);
        if (value instanceof LongValue) {
            queryId = ((LongValue)value).getValue();
        }
        return queryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryCreate(Message message) {
        Long queryId = this.queryIdFromMessage(message);
        if (queryId == null) {
            logger.warn("Unable to create query without query id");
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Unable to create query without query id"));
            return;
        }
        String queryType = null;
        Value value = message.getValues().get("queryType");
        if (value instanceof StringValue) {
            queryType = ((StringValue)value).getValue();
        }
        String queryData = null;
        Value value2 = message.getValues().get("queryData");
        if (value2 instanceof StringValue) {
            queryData = ((StringValue)value2).getValue();
        }
        if (queryType == null || queryData == null) {
            logger.warn("Query without queryType and queryData is not allowed");
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Query without queryType and queryData is not allowed"));
            return;
        }
        ServerConnectionHandler serverConnectionHandler = this;
        synchronized (serverConnectionHandler) {
            if (this.queries.containsKey(queryId)) {
                String msg = String.format("A query with id {} already exisits", queryId);
                logger.warn(msg);
                this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)msg));
                return;
            }
            QueryImpl query = new QueryImpl(queryId, this);
            try {
                Query queryHandle = this.service.createQuery(this.session, queryType, queryData, (QueryListener)query);
                query.setQuery(queryHandle);
                this.queries.put(queryId, query);
            }
            catch (InvalidSessionException invalidSessionException) {
                logger.warn("Query without queryType and queryData is not allowed");
                this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Query without queryType and queryData is not allowed"));
            }
        }
    }

    protected synchronized void queryClose(Message message) {
        Long queryId = this.queryIdFromMessage(message);
        if (queryId == null) {
            logger.warn("Unable to create query without query id");
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Unable to create query without query id"));
            return;
        }
        QueryImpl query = this.queries.get(queryId);
        if (query == null) {
            String msg = String.format("No query with id {} exisits", queryId);
            logger.warn(msg);
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)msg));
            return;
        }
        query.close();
    }

    protected synchronized void queryLoadMore(Message message) {
        Long queryId = this.queryIdFromMessage(message);
        if (queryId == null) {
            logger.warn("Unable to create query without query id");
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Unable to create query without query id"));
            return;
        }
        QueryImpl query = this.queries.get(queryId);
        if (query == null) {
            String msg = String.format("No query with id {} exisits", queryId);
            logger.warn(msg);
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)msg));
            return;
        }
        Integer count = 100;
        Value value = message.getValues().get("count");
        if (value instanceof IntegerValue) {
            count = ((IntegerValue)value).getValue();
        }
        query.loadMore(count);
    }

    protected void acknowledge(final Message message) {
        String monitorId = null;
        Date aknTimestamp = null;
        Value value = message.getValues().get("id");
        if (value instanceof StringValue) {
            monitorId = value.toString();
        }
        if ((value = message.getValues().get("aknTimestamp")) instanceof LongValue) {
            aknTimestamp = new Date(((LongValue)value).getValue());
        }
        UserInformation userInformation = null;
        Value value2 = message.getValues().get("user");
        if (value2 instanceof StringValue) {
            String user = value2.toString();
            userInformation = new UserInformation(user);
        }
        if (monitorId != null && aknTimestamp != null) {
            try {
                NotifyFuture future = this.service.acknowledge(this.session, monitorId, aknTimestamp, new OperationParameters(userInformation, Collections.emptyMap()), null);
                future.addListener((FutureListener)new FutureListener<Void>(){

                    public void complete(Future<Void> future) {
                        try {
                            future.get();
                        }
                        catch (Exception e) {
                            ServerConnectionHandler.this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (Throwable)e));
                        }
                    }
                });
            }
            catch (Throwable e) {
                this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (Throwable)e));
            }
        }
    }

    protected void subscribeEventPool(Message message) {
        Value value = message.getValues().get(MESSAGE_QUERY_ID);
        String queryId = null;
        if (value instanceof StringValue) {
            queryId = ((StringValue)value).getValue();
        }
        try {
            this.service.subscribeEventQuery(this.session, queryId);
            MessageCreator.createACK((Message)message);
        }
        catch (InvalidSessionException e) {
            this.closeSession();
            MessageCreator.createFailedMessage((Message)message, (Throwable)e);
        }
        catch (UnknownQueryException e) {
            MessageCreator.createFailedMessage((Message)message, (Throwable)e);
        }
    }

    protected void unsubscribeEventPool(Message message) {
        Value value = message.getValues().get(MESSAGE_QUERY_ID);
        String queryId = null;
        if (value instanceof StringValue) {
            queryId = ((StringValue)value).getValue();
        }
        try {
            this.service.unsubscribeEventQuery(this.session, queryId);
            MessageCreator.createACK((Message)message);
        }
        catch (InvalidSessionException e) {
            this.closeSession();
            MessageCreator.createFailedMessage((Message)message, (Throwable)e);
        }
    }

    protected void subscribeMonitors(Message message) {
        Value value = message.getValues().get(MESSAGE_QUERY_ID);
        String queryId = null;
        if (value instanceof StringValue) {
            queryId = ((StringValue)value).getValue();
        }
        try {
            this.service.subscribeConditionQuery(this.session, queryId);
            MessageCreator.createACK((Message)message);
        }
        catch (InvalidSessionException e) {
            this.closeSession();
            MessageCreator.createFailedMessage((Message)message, (Throwable)e);
        }
        catch (UnknownQueryException e) {
            MessageCreator.createFailedMessage((Message)message, (Throwable)e);
        }
    }

    protected void unsubscribeMonitors(Message message) {
        Value value = message.getValues().get(MESSAGE_QUERY_ID);
        String queryId = null;
        if (value instanceof StringValue) {
            queryId = ((StringValue)value).getValue();
        }
        try {
            this.service.unsubscribeConditionQuery(this.session, queryId);
            MessageCreator.createACK((Message)message);
        }
        catch (InvalidSessionException e) {
            this.closeSession();
            MessageCreator.createFailedMessage((Message)message, (Throwable)e);
        }
    }

    private void createSession(final Message message) {
        if (this.session != null) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Connection already bound to a session"));
            return;
        }
        final Properties props = new Properties();
        MessageHelper.getProperties((Properties)props, (Value)message.getValues().get("properties"));
        String clientVersion = props.getProperty("client-version", "");
        if (clientVersion.equals("")) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"client does not pass \"client-version\" property! You may need to upgrade your client!"));
            return;
        }
        if (!clientVersion.equals(VERSION)) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)String.format("protocol version mismatch: client '%s' server: '%s'", clientVersion, VERSION)));
            return;
        }
        this.service.createSession(props, this.createDefaultContext(), (CallbackHandler)new PropertiesCredentialsCallback(props)).addListener((FutureListener)new FutureListener<Session>(){

            public void complete(Future<Session> future) {
                ServerConnectionHandler.this.handleCreateSessionComplete(future, message, props);
            }
        });
    }

    protected void handleCreateSessionComplete(Future<Session> future, Message message, Properties props) {
        try {
            this.session = future.get();
        }
        catch (Exception e) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (Throwable)e));
            return;
        }
        if (this.session == null) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"unable to create session"));
            return;
        }
        this.eventListener = new EventListener(){

            public void dataChanged(String poolId, List<Event> addedEvents) {
                ServerConnectionHandler.this.dataChangedEvents(poolId, addedEvents);
            }

            public void updateStatus(String topic, SubscriptionState state) {
                ServerConnectionHandler.this.statusChangedEvents(topic.toString(), state);
            }
        };
        this.session.setEventListener(this.eventListener);
        this.monitorListener = new MonitorListener(){

            public void dataChanged(String subscriptionId, List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
                ServerConnectionHandler.this.dataChangedConditions(subscriptionId, addedOrUpdated, removed, full);
            }

            public void updateStatus(String topic, SubscriptionState state) {
                ServerConnectionHandler.this.statusChangedConditions(topic.toString(), state);
            }
        };
        this.session.setMonitorListener(this.monitorListener);
        this.session.setBrowserListener((BrowserListener)this);
        this.replySessionCreated(props, message, this.session.getProperties());
        this.session.addSessionListener(new Session.SessionListener(){

            public void privilegeChange() {
                ServerConnectionHandler.this.sendPrivilegeChange(ServerConnectionHandler.this.session.getPrivileges());
            }
        });
    }

    protected void cleanUp() {
        super.cleanUp();
        this.disposeSession();
    }

    private void disposeSession() {
        if (this.session != null) {
            Session session = this.session;
            this.session = null;
            try {
                session.setMonitorListener(null);
                session.setEventListener(null);
                session.setBrowserListener(null);
                this.service.closeSession((org.eclipse.scada.core.server.Session)session);
            }
            catch (InvalidSessionException e) {
                logger.warn("Failed to close session", (Throwable)e);
            }
        }
    }

    private void closeSession() {
        this.cleanUp();
    }

    private <T> void scheduleTask(NotifyFuture<T> task, long id, ResultHandler<T> resultHandler) {
        task.addListener((FutureListener)new ResultFutureHandler(resultHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTask(long id) {
        Set<Long> set = this.taskMap;
        synchronized (set) {
            this.taskMap.remove(id);
        }
    }

    public void dataChangedEvents(String poolId, List<Event> addedEvents) {
        for (List chunk : Lists.partition(addedEvents, (int)this.getChunkSize())) {
            Message message = new Message(196612);
            message.getValues().put(MESSAGE_QUERY_ID, (Value)new StringValue(poolId));
            message.getValues().put("events", EventMessageHelper.toValue((Collection)chunk));
            this.messenger.sendMessage(message);
        }
    }

    private int getChunkSize() {
        return Integer.getInteger("org.eclipse.scada.ae.server.net.ServerConnectionHandler.chunkSize", 200);
    }

    public void statusChangedEvents(String poolId, SubscriptionState status) {
        Message message = new Message(196611);
        message.getValues().put(MESSAGE_QUERY_ID, (Value)new StringValue(poolId));
        message.getValues().put("status", (Value)new StringValue(status.toString()));
        this.messenger.sendMessage(message);
    }

    public void dataChangedConditions(String subscriptionId, List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
        Message message = new Message(196628);
        message.getValues().put(MESSAGE_QUERY_ID, (Value)new StringValue(subscriptionId));
        message.getValues().put("conditions.addedOrUpdated", MonitorMessageHelper.toValue(addedOrUpdated));
        message.getValues().put("conditions.removed", MonitorMessageHelper.toValue(removed));
        if (full) {
            message.getValues().put("full", (Value)VoidValue.INSTANCE);
        }
        this.messenger.sendMessage(message);
    }

    public void statusChangedConditions(String subscriptionId, SubscriptionState status) {
        Message message = new Message(196627);
        message.getValues().put(MESSAGE_QUERY_ID, (Value)new StringValue(subscriptionId));
        message.getValues().put("status", (Value)new StringValue(status.toString()));
        this.messenger.sendMessage(message);
    }

    public void dataChanged(List<BrowserEntry> addedOrUpdated, Set<String> removed, boolean full) {
        Message message = new Message(196641);
        message.getValues().put("added", BrowserMessageHelper.toValue(addedOrUpdated));
        message.getValues().put("removed", BrowserMessageHelper.toValue(removed));
        if (full) {
            message.getValues().put("full", (Value)VoidValue.INSTANCE);
        }
        this.messenger.sendMessage(message);
    }

    public void sendQueryData(QueryImpl queryImpl, List<Event> events) {
        for (List chunk : Lists.partition(events, (int)this.getChunkSize())) {
            Message message = new Message(196660);
            message.getValues().put("data", EventMessageHelper.toValue((Collection)chunk));
            message.getValues().put(MESSAGE_QUERY_ID, (Value)new LongValue(queryImpl.getQueryId()));
            this.messenger.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueryState(QueryImpl queryImpl, QueryState state, Throwable error) {
        ServerConnectionHandler serverConnectionHandler = this;
        synchronized (serverConnectionHandler) {
            if (state == QueryState.DISCONNECTED) {
                this.queries.remove(queryImpl.getQueryId());
            }
        }
        Message message = new Message(196659);
        message.getValues().put("state", (Value)new StringValue(state.name()));
        message.getValues().put(MESSAGE_QUERY_ID, (Value)new LongValue(queryImpl.getQueryId()));
        if (error != null) {
            message.getValues().put("error", (Value)new StringValue(error.getMessage()));
        }
        this.messenger.sendMessage(message);
    }
}

