/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.file.internal;

import com.google.common.collect.Interner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.scada.ca.common.AbstractConfigurationAdministrator;
import org.eclipse.scada.ca.common.ConfigurationImpl;
import org.eclipse.scada.ca.oscar.OscarLoader;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.str.StringReplacer;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationAdminImpl
extends AbstractConfigurationAdministrator {
    private static final String URI_CHARSET = "UTF-8";
    private static final String META_FILE = ".meta";
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationAdminImpl.class);
    private static final String STORE = "scadaConfigStore";
    private final BundleContext context;
    private File root;
    private final Interner<String> stringInterner;

    public ConfigurationAdminImpl(BundleContext context, Interner<String> stringInterner) throws Exception {
        super(context);
        this.stringInterner = stringInterner;
        this.context = context;
        this.initRoot();
    }

    protected String intern(String string) {
        return (String)this.stringInterner.intern((Object)string);
    }

    protected File getRootFile() {
        String rootDir = this.getRootFileName();
        if (rootDir == null || rootDir.isEmpty()) {
            return this.context.getDataFile(STORE);
        }
        return new File(rootDir);
    }

    private String getRootFileName() {
        return StringReplacer.replace((String)System.getProperty("org.eclipse.scada.ca.file.root", null), (Map)System.getProperties());
    }

    private void initRoot() throws Exception {
        this.root = this.getRootFile();
        if (this.root != null) {
            logger.info("Checking CA root at: {}", (Object)this.root.getAbsolutePath());
            if (!this.root.exists()) {
                logger.warn("Storage root does not exist: {}, Try to provision...", (Object)this.root);
                this.root.mkdirs();
                this.provisionData();
            }
            if (!this.root.isDirectory()) {
                logger.warn("File exists but is not a directory: {}", (Object)this.root);
                this.root = null;
            }
        } else {
            logger.warn("No file system support");
        }
    }

    protected void provisionData() throws Exception {
        String oscarUrl = System.getProperty("org.eclipse.scada.ca.file.provisionOscarUrl");
        if (oscarUrl != null) {
            logger.info("Provisioning CA from: oscar {}", (Object)oscarUrl);
            InputStream stream = new URL(oscarUrl).openStream();
            try {
                this.performOscarProvision(stream);
            }
            finally {
                stream.close();
            }
            return;
        }
        String jsonUrl = System.getProperty("org.eclipse.scada.ca.file.provisionJsonUrl");
        if (jsonUrl != null) {
            logger.info("Provisioning CA from: json {}", (Object)jsonUrl);
            InputStream stream = new URL(jsonUrl).openStream();
            try {
                this.performProvision(OscarLoader.loadJsonData((InputStream)stream));
            }
            finally {
                stream.close();
            }
        }
    }

    private void performProvision(Map<String, Map<String, Map<String, String>>> json) {
        for (Map.Entry<String, Map<String, Map<String, String>>> factory : json.entrySet()) {
            String factoryId = factory.getKey();
            for (Map.Entry<String, Map<String, String>> cfg : factory.getValue().entrySet()) {
                try {
                    this.writeConfiguraton(factoryId, cfg.getKey(), cfg.getValue(), true);
                }
                catch (Exception e) {
                    logger.warn(String.format("Failed to provision - %s/%s", factoryId, cfg.getKey()), (Throwable)e);
                }
            }
        }
    }

    private void performOscarProvision(InputStream stream) throws Exception {
        this.performProvision(new OscarLoader(stream).getData());
    }

    public synchronized void start() throws Exception {
        super.start();
        long start = System.currentTimeMillis();
        this.performInitialLoad();
        logger.info("Took {} seconds to initial load CA", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    protected void performInitialLoad() {
        logger.info("Loading initial set from: {}", (Object)this.root);
        if (this.root == null) {
            logger.warn("No root found");
            return;
        }
        String[] stringArray = this.root.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pathName = stringArray[n2];
            try {
                File path = new File(this.root, pathName);
                if (path.isDirectory()) {
                    logger.debug("Checking for path: {}", (Object)path.getName());
                    String factoryId = this.detectFactory(path);
                    if (factoryId != null) {
                        logger.debug(String.format("Path %s is a possible factory (%s). Adding...", path.getName(), factoryId));
                        this.performLoadFactory(factoryId);
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Failed to load factory: " + pathName, (Throwable)e);
            }
            ++n2;
        }
    }

    private String detectFactory(File path) {
        File meta = new File(path, META_FILE);
        Properties p = new Properties();
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(meta);
                p.load(stream);
            }
            catch (Exception exception) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        logger.warn("Failed to close stream", (Throwable)e);
                    }
                }
                return null;
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.warn("Failed to close stream", (Throwable)e);
                }
            }
        }
        return p.getProperty("id");
    }

    protected void performLoadFactory(String factoryId) throws Exception {
        if (this.root == null) {
            logger.warn("No root found");
            return;
        }
        File path = this.getFactoryPath(factoryId);
        this.loadAll(path, factoryId);
    }

    private void createStore(File factoryRoot, String factoryId) {
        block13: {
            if (!factoryRoot.mkdir()) {
                logger.warn("Failed to create store: {}", (Object)factoryRoot);
                return;
            }
            File meta = new File(factoryRoot, META_FILE);
            Properties p = new Properties();
            p.put("id", factoryId);
            FileOutputStream stream = null;
            try {
                try {
                    stream = new FileOutputStream(meta);
                    logger.debug("Creating new store: {}", (Object)factoryRoot);
                    p.store(stream, "");
                }
                catch (Exception exception) {
                    logger.warn("Failed to initialize store: {}", (Object)factoryRoot);
                    if (stream == null) break block13;
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        logger.warn("Failed to close stream", (Throwable)e);
                    }
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        logger.warn("Failed to close stream", (Throwable)e);
                    }
                }
            }
        }
    }

    private void loadAll(File configurationRoot, String factoryId) throws UnsupportedEncodingException {
        logger.debug("Loading from: {}", (Object)configurationRoot.getName());
        LinkedList<ConfigurationImpl> configurations = new LinkedList<ConfigurationImpl>();
        File[] fileArray = configurationRoot.listFiles(new DataFilenameFilter());
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            logger.trace("Loading file: {}", (Object)file.getName());
            String id = this.idFromFile(file);
            ConfigurationImpl cfg = this.loadConfiguration(factoryId, id, file);
            if (cfg != null) {
                configurations.add(cfg);
            }
            ++n2;
        }
        this.addStoredFactory(factoryId, configurations.toArray(new ConfigurationImpl[configurations.size()]));
    }

    private ConfigurationImpl loadConfiguration(String factoryId, String configurationId, File file) {
        try {
            Properties p = new Properties();
            FileInputStream stream = new FileInputStream(file);
            try {
                p.load(stream);
            }
            finally {
                stream.close();
            }
            HashMap<String, String> result = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                result.put(this.intern(entry.getKey().toString()), this.intern(entry.getValue().toString()));
            }
            return new ConfigurationImpl(configurationId, factoryId, result);
        }
        catch (Throwable throwable) {
            logger.warn("Failed to load");
            return null;
        }
    }

    private String getPath(String factoryId) throws UnsupportedEncodingException {
        return this.encode(factoryId);
    }

    private String encode(String path) throws UnsupportedEncodingException {
        return URLEncoder.encode(path, URI_CHARSET);
    }

    private String idFromFile(File file) throws UnsupportedEncodingException {
        String name = file.getName();
        return URLDecoder.decode(name, URI_CHARSET);
    }

    protected void performPurge(UserInformation userInformation, String factoryId, AbstractConfigurationAdministrator.PurgeFuture future) throws Exception {
        logger.info("Request to delete: {}", (Object)factoryId);
        if (this.root == null) {
            logger.warn("Unable to store : no root");
            return;
        }
        File path = this.getFactoryPath(factoryId);
        File[] fileArray = path.listFiles(new DataFilenameFilter());
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            logger.info("Delete file: {}", (Object)file.getName());
            String id = this.idFromFile(file);
            AbstractConfigurationAdministrator.ConfigurationFuture subFuture = new AbstractConfigurationAdministrator.ConfigurationFuture();
            this.changeConfiguration(userInformation, factoryId, id, null, subFuture);
            future.addChild((NotifyFuture)subFuture);
            file.delete();
            ++n2;
        }
        File metaFile = new File(path, META_FILE);
        metaFile.delete();
        logger.debug("Delete factory root: {}", (Object)path);
        path.delete();
        future.setComplete();
    }

    protected Map<String, String> writeConfiguraton(String factoryId, String configurationId, Map<String, String> properties, boolean fullSet) throws Exception {
        ConfigurationImpl oldConfig;
        if (this.root == null) {
            logger.warn("Unable to store : no root");
            throw new RuntimeException("No root to store");
        }
        File path = this.getFactoryPath(factoryId);
        File file = new File(path, this.encode(configurationId));
        logger.info("Storing {} to {}", (Object)configurationId, (Object)file);
        HashMap<String, String> newProperties = new HashMap<String, String>();
        if (!fullSet && (oldConfig = this.loadConfiguration(factoryId, configurationId, file)) != null) {
            newProperties.putAll(oldConfig.getData());
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value != null) {
                newProperties.put(this.intern(key), this.intern(value));
                continue;
            }
            newProperties.remove(key);
        }
        Properties p = new Properties();
        p.putAll((Map<?, ?>)newProperties);
        FileOutputStream stream = new FileOutputStream(file);
        try {
            logger.debug("Storing {}/{} -> {}", new Object[]{factoryId, configurationId, newProperties});
            p.store(stream, "");
        }
        finally {
            stream.close();
        }
        return newProperties;
    }

    protected void performStoreConfiguration(UserInformation userInformation, String factoryId, String configurationId, Map<String, String> properties, boolean fullSet, AbstractConfigurationAdministrator.ConfigurationFuture future) throws FileNotFoundException, IOException {
        try {
            Map<String, String> newProperties = this.writeConfiguraton(factoryId, configurationId, properties, fullSet);
            this.changeConfiguration(userInformation, factoryId, configurationId, newProperties, future);
        }
        catch (Exception e) {
            future.setError((Throwable)e);
            return;
        }
    }

    private File getFactoryPath(String factoryId) throws UnsupportedEncodingException {
        File path = new File(this.root, this.getPath(factoryId));
        if (!path.exists()) {
            logger.info("Store for factory ({}) does not exist", (Object)factoryId);
            this.createStore(path, factoryId);
        }
        return path;
    }

    protected void performDeleteConfiguration(UserInformation userInformation, String factoryId, String configurationId, AbstractConfigurationAdministrator.ConfigurationFuture future) throws Exception {
        File path = this.getFactoryPath(factoryId);
        File file = new File(path, this.encode(configurationId));
        logger.info("Deleting {}", (Object)configurationId);
        if (!file.delete()) {
            logger.info("Failed to delete: {}", (Object)file);
        }
        this.changeConfiguration(userInformation, factoryId, configurationId, null, future);
    }

    private static final class DataFilenameFilter
    implements FilenameFilter {
        private DataFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return !ConfigurationAdminImpl.META_FILE.equals(name);
        }
    }
}

