/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.server.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.server.Service;
import org.eclipse.scada.ca.server.osgi.ServiceImpl;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private static BundleContext context;
    private SingleServiceTracker<ConfigurationAdministrator> tracker;
    private Service service;
    private ServiceRegistration<Service> handle;
    private ExportedExecutorService executor;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.executor = new ExportedExecutorService("org.eclipse.scada.ca.server.osgi", 1, 1, 1L, TimeUnit.MINUTES);
        context = bundleContext;
        this.tracker = new SingleServiceTracker(bundleContext, ConfigurationAdministrator.class, (SingleServiceListener)new SingleServiceListener<ConfigurationAdministrator>(){

            public void serviceChange(ServiceReference<ConfigurationAdministrator> reference, ConfigurationAdministrator service) {
                Activator.this.setService(service);
            }
        });
        this.tracker.open();
    }

    protected void setService(ConfigurationAdministrator service) {
        if (this.handle != null) {
            this.handle.unregister();
            this.handle = null;
        }
        if (this.service != null) {
            try {
                this.service.stop();
            }
            catch (Exception e) {
                logger.warn("Failed to stop service", (Throwable)e);
            }
            this.service = null;
        }
        if (service != null) {
            try {
                ServiceImpl newService = new ServiceImpl(service, context, (Executor)this.executor);
                newService.start();
                this.service = newService;
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
                ((Dictionary)properties).put("service.description", "Eclipse SCADA CA Server Interface");
                this.handle = context.registerService(Service.class, (Object)this.service, properties);
            }
            catch (Exception e) {
                logger.warn("Failed to start new service", (Throwable)e);
            }
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.tracker.close();
        context = null;
        this.executor.shutdown();
    }
}

