/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.browser.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.core.server.browser.NoSuchFolderException;
import org.eclipse.scada.da.server.browser.common.DataItemEntryCommon;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderEntryCommon;
import org.eclipse.scada.da.server.browser.common.FolderListener;
import org.eclipse.scada.da.server.common.DataItem;

public class FolderCommon
implements Folder {
    private final Map<String, Entry> entryMap = new HashMap<String, Entry>();
    private final Map<Object, FolderListener> listeners = new HashMap<Object, FolderListener>();

    @Override
    public Entry[] list(Stack<String> path) throws NoSuchFolderException {
        if (path.isEmpty()) {
            return this.getAllEntries();
        }
        return this.getFolderEntry(path.pop()).list(path);
    }

    private synchronized Entry[] getAllEntries() {
        return this.entryMap.values().toArray(new Entry[this.entryMap.size()]);
    }

    private synchronized Entry getEntry(String name) {
        return this.entryMap.get(name);
    }

    private Folder getFolderEntry(String name) throws NoSuchFolderException {
        Entry entry = this.getEntry(name);
        if (entry instanceof FolderEntryCommon) {
            return ((FolderEntryCommon)entry).getFolder();
        }
        throw new NoSuchFolderException(new String[]{name});
    }

    public synchronized int add(Map<String, Folder> folders, Map<String, DataItemInformation> items) {
        Object entry;
        String name;
        int size = 0;
        if (folders != null) {
            size += folders.size();
        }
        if (items != null) {
            size += items.size();
        }
        ArrayList<Entry> entries = new ArrayList<Entry>(size);
        if (folders != null) {
            for (Map.Entry<String, Folder> entry2 : folders.entrySet()) {
                name = entry2.getKey();
                Folder folder = entry2.getValue();
                if (this.entryMap.containsKey(name)) continue;
                entry = new FolderEntryCommon(name, folder, null);
                this.entryMap.put(name, (Entry)entry);
                folder.added();
                entries.add((Entry)entry);
            }
        }
        if (items != null) {
            for (Map.Entry<String, Folder> entry3 : items.entrySet()) {
                name = entry3.getKey();
                DataItemInformation itemInformation = (DataItemInformation)entry3.getValue();
                if (this.entryMap.containsKey(name)) continue;
                entry = new DataItemEntryCommon(name, itemInformation, null);
                this.entryMap.put(name, (Entry)entry);
                entries.add((Entry)entry);
            }
        }
        if (!entries.isEmpty()) {
            this.notifyAdd(entries);
        }
        return entries.size();
    }

    public synchronized boolean add(String name, Folder folder, Map<String, Variant> attributes) {
        if (!this.entryMap.containsKey(name)) {
            FolderEntryCommon entry = new FolderEntryCommon(name, folder, attributes);
            this.entryMap.put(name, (Entry)entry);
            this.notifyAdd((Entry)entry);
            folder.added();
            return true;
        }
        return false;
    }

    public boolean add(String name, DataItem dataItem, Map<String, Variant> attributes) {
        return this.add(name, dataItem.getInformation(), attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String name, DataItemInformation itemInformation, Map<String, Variant> attributes) {
        if (itemInformation == null || itemInformation.getName() == null) {
            throw new NullPointerException("Item must have an id");
        }
        FolderCommon folderCommon = this;
        synchronized (folderCommon) {
            block5: {
                if (this.entryMap.containsKey(name)) break block5;
                DataItemEntryCommon entry = new DataItemEntryCommon(name, itemInformation, attributes);
                this.entryMap.put(name, (Entry)entry);
                this.notifyAdd((Entry)entry);
                return true;
            }
            return false;
        }
    }

    public synchronized boolean remove(String name) {
        if (this.entryMap.containsKey(name)) {
            Entry entry = this.entryMap.remove(name);
            if (entry instanceof FolderEntryCommon) {
                ((FolderEntryCommon)entry).getFolder().removed();
            }
            this.notifyRemove(name);
            return true;
        }
        return false;
    }

    public synchronized String findEntry(DataItem item) {
        Iterator<Map.Entry<String, Entry>> i = this.entryMap.entrySet().iterator();
        while (i.hasNext()) {
            String itemId = item.getInformation().getName();
            Map.Entry<String, Entry> entry = i.next();
            if (!(entry.getValue() instanceof DataItemEntryCommon) || ((DataItemEntryCommon)entry.getValue()).getId() != itemId) continue;
            return entry.getKey();
        }
        return null;
    }

    public synchronized String findEntry(Folder folder) {
        for (Map.Entry<String, Entry> entry : this.entryMap.entrySet()) {
            if (!(entry.getValue() instanceof FolderEntryCommon) || ((FolderEntryCommon)entry.getValue()).getFolder() != folder) continue;
            return entry.getKey();
        }
        return null;
    }

    public synchronized boolean remove(Folder folder) {
        Iterator<Map.Entry<String, Entry>> i = this.entryMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Entry> entry = i.next();
            if (!(entry.getValue() instanceof FolderEntryCommon) || ((FolderEntryCommon)entry.getValue()).getFolder() != folder) continue;
            i.remove();
            folder.removed();
            this.notifyRemove(entry.getKey());
            return true;
        }
        return false;
    }

    public synchronized boolean remove(DataItem item) {
        Iterator<Map.Entry<String, Entry>> i = this.entryMap.entrySet().iterator();
        while (i.hasNext()) {
            String itemId = item.getInformation().getName();
            Map.Entry<String, Entry> entry = i.next();
            if (!(entry.getValue() instanceof DataItemEntryCommon) || ((DataItemEntryCommon)entry.getValue()).getId() != itemId) continue;
            i.remove();
            this.notifyRemove(entry.getKey());
            return true;
        }
        return false;
    }

    @Override
    public void subscribe(Stack<String> path, FolderListener listener, Object tag) throws NoSuchFolderException {
        if (path.isEmpty()) {
            this.addListener(listener, tag);
        } else {
            this.getFolderEntry(path.pop()).subscribe(path, listener, tag);
        }
    }

    @Override
    public void unsubscribe(Stack<String> path, Object tag) throws NoSuchFolderException {
        if (path.isEmpty()) {
            this.removeListener(tag);
        } else {
            this.getFolderEntry(path.pop()).unsubscribe(path, tag);
        }
    }

    private synchronized void addListener(FolderListener listener, Object tag) {
        this.listeners.put(tag, listener);
        this.sendCurrentList(listener, tag);
    }

    private synchronized void removeListener(Object tag) {
        this.listeners.remove(tag);
    }

    public synchronized void clearListeners() {
        this.listeners.clear();
    }

    public synchronized boolean hasSubscribers() {
        return !this.listeners.isEmpty();
    }

    private synchronized void sendCurrentList(FolderListener listener, Object tag) {
        listener.changed(tag, new ArrayList<Entry>(this.entryMap.values()), Collections.emptySet(), true);
    }

    private synchronized void notifyAdd(List<Entry> added) {
        for (Map.Entry<Object, FolderListener> entry : this.listeners.entrySet()) {
            entry.getValue().changed(entry.getKey(), added, Collections.emptySet(), false);
        }
    }

    private synchronized void notifyAdd(Entry added) {
        this.notifyAdd(Arrays.asList(added));
    }

    private synchronized void notifyRemove(String removed) {
        Set<String> list = Collections.singleton(removed);
        for (Map.Entry<Object, FolderListener> entry : this.listeners.entrySet()) {
            entry.getValue().changed(entry.getKey(), Collections.emptyList(), list, false);
        }
    }

    public int size() {
        return this.entryMap.size();
    }

    @Override
    public void added() {
    }

    @Override
    public void removed() {
        this.clearListeners();
    }

    public synchronized void clear() {
        for (Map.Entry<Object, FolderListener> entry : this.listeners.entrySet()) {
            entry.getValue().changed(entry.getKey(), Collections.emptyList(), Collections.emptySet(), true);
        }
        for (Map.Entry<Object, FolderListener> entry : this.entryMap.entrySet()) {
            if (!(entry instanceof FolderEntryCommon)) continue;
            ((FolderEntryCommon)((Object)entry)).getFolder().removed();
        }
        this.entryMap.clear();
    }
}

