/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.browser.common.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.browser.common.query.NameProvider;

public class PatternNameProvider
implements NameProvider {
    private final NameProvider provider;
    private final Pattern pattern;
    private final int groupNumber;

    public PatternNameProvider(NameProvider provider, Pattern pattern, int groupNumber) {
        this.pattern = pattern;
        this.provider = provider;
        this.groupNumber = groupNumber;
    }

    @Override
    public String getName(ItemDescriptor descriptor) {
        try {
            String name = this.provider.getName(descriptor);
            Matcher m = this.pattern.matcher(this.provider.getName(descriptor));
            if (m.matches()) {
                return m.group(this.groupNumber);
            }
            return name;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

