/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.component;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.browser.common.query.ItemStorage;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.component.Hive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentItemFactory {
    private static final Logger logger = LoggerFactory.getLogger(ComponentItemFactory.class);
    private final Hive hive;
    private final ItemStorage storage;
    private final String prefix;
    private final Map<String, ItemDescriptor> items = new HashMap<String, ItemDescriptor>();

    public ComponentItemFactory(Hive hive, ItemStorage storage, String prefix) {
        this.hive = hive;
        this.storage = storage;
        this.prefix = prefix;
    }

    public void dispose() {
        for (ItemDescriptor desc : this.items.values()) {
            this.storage.removed(desc);
            this.hive.unregisterItem(desc.getItem());
        }
        this.items.clear();
    }

    public DataItemInputChained createInput(String localId, Map<String, Variant> attributes) {
        DataItemInputChained item = new DataItemInputChained((DataItemInformation)new DataItemInformationBase(this.makeId(localId), EnumSet.of(IODirection.INPUT)), this.hive.getOperationService());
        ItemDescriptor desc = new ItemDescriptor((DataItem)item, attributes);
        this.hive.registerItem((DataItem)item);
        this.storage.added(desc);
        this.items.put(localId, desc);
        return item;
    }

    private String makeId(String id) {
        return String.valueOf(this.prefix) + "." + id;
    }

    public void disposeItem(String localId) {
        logger.debug("Dispose item: {}", (Object)localId);
        ItemDescriptor desc = this.items.remove(localId);
        if (desc == null) {
            logger.debug("Item not found");
            return;
        }
        this.hive.unregisterItem(desc.getItem());
        this.storage.removed(desc);
    }
}

