/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.da.exec.configuration.ConfigurationPackage;
import org.eclipse.scada.da.exec.configuration.DocumentRoot;
import org.eclipse.scada.da.exec.configuration.EnvEntryType;
import org.eclipse.scada.da.exec.configuration.ExtractorType;
import org.eclipse.scada.da.exec.configuration.FieldExtractorType;
import org.eclipse.scada.da.exec.configuration.FieldType;
import org.eclipse.scada.da.exec.configuration.HiveProcessCommandType;
import org.eclipse.scada.da.exec.configuration.NagiosReturnCodeExtractorType;
import org.eclipse.scada.da.exec.configuration.PlainStreamExtractorType;
import org.eclipse.scada.da.exec.configuration.ProcessType;
import org.eclipse.scada.da.exec.configuration.QueueType;
import org.eclipse.scada.da.exec.configuration.RegExExtractorType;
import org.eclipse.scada.da.exec.configuration.ReturnCodeExtractorType;
import org.eclipse.scada.da.exec.configuration.RootType;
import org.eclipse.scada.da.exec.configuration.SingleCommandType;
import org.eclipse.scada.da.exec.configuration.SplitContinuousCommandType;
import org.eclipse.scada.da.exec.configuration.SplitterExtractorType;
import org.eclipse.scada.da.exec.configuration.SplitterType;
import org.eclipse.scada.da.exec.configuration.TriggerCommandType;
import org.eclipse.scada.da.exec.configuration.util.ConfigurationResourceFactoryImpl;
import org.eclipse.scada.da.server.exec.Hive;
import org.eclipse.scada.da.server.exec.command.CommandQueue;
import org.eclipse.scada.da.server.exec.command.CommandQueueImpl;
import org.eclipse.scada.da.server.exec.command.ContinuousCommand;
import org.eclipse.scada.da.server.exec.command.ExtractorContinuousCommand;
import org.eclipse.scada.da.server.exec.command.HiveProcessCommand;
import org.eclipse.scada.da.server.exec.command.ProcessConfiguration;
import org.eclipse.scada.da.server.exec.command.SingleCommand;
import org.eclipse.scada.da.server.exec.command.SingleCommandImpl;
import org.eclipse.scada.da.server.exec.command.TriggerCommand;
import org.eclipse.scada.da.server.exec.configuration.ConfigurationException;
import org.eclipse.scada.da.server.exec.configuration.Configurator;
import org.eclipse.scada.da.server.exec.extractor.AbstractArrayExtractor;
import org.eclipse.scada.da.server.exec.extractor.Extractor;
import org.eclipse.scada.da.server.exec.extractor.NagiosExtractor;
import org.eclipse.scada.da.server.exec.extractor.PlainStreamExtractor;
import org.eclipse.scada.da.server.exec.extractor.RegExExtractor;
import org.eclipse.scada.da.server.exec.extractor.SimpleReturnCodeExtractor;
import org.eclipse.scada.da.server.exec.extractor.SplitterExtractor;
import org.eclipse.scada.da.server.exec.splitter.RegExMatchSplitter;
import org.eclipse.scada.da.server.exec.splitter.RegExSplitSplitter;
import org.eclipse.scada.da.server.exec.splitter.SplitSplitter;
import org.eclipse.scada.da.server.exec.splitter.Splitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlConfigurator
implements Configurator {
    private static final Logger logger = LoggerFactory.getLogger(XmlConfigurator.class);
    private RootType root;

    public XmlConfigurator(RootType root) {
        this.root = root;
    }

    public XmlConfigurator(URI uri) throws ConfigurationException {
        try {
            this.root = this.parse(uri);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to parse xml document", e);
        }
    }

    @Override
    public void configure(Hive hive) throws ConfigurationException {
        this.configure(this.root, hive);
    }

    private void configure(RootType root, Hive hive) throws ConfigurationException {
        Object command;
        ProcessConfiguration processConfiguration;
        for (QueueType queueType : root.getQueue()) {
            CommandQueueImpl queue = new CommandQueueImpl(hive, queueType.getName(), 1000);
            this.configureQueue(queue, queueType, hive);
            hive.addQueue(queue);
        }
        for (SplitContinuousCommandType commandType : root.getCommand()) {
            processConfiguration = this.createProcessConfiguration(commandType.getProcess());
            Splitter splitter = this.createSplitter(commandType.getSplitter());
            if (splitter == null) {
                throw new ConfigurationException(String.format("Unable to create splitter: " + commandType.getSplitter().getType(), new Object[0]));
            }
            command = new ExtractorContinuousCommand(commandType.getId(), processConfiguration, commandType.getRestartDelay(), commandType.getMaxInputBuffer(), commandType.getIgnoreStartLines(), splitter, this.createExtractors((List<ExtractorType>)commandType.getExtractor(), hive));
            hive.addContinuousCommand((ContinuousCommand)command);
        }
        for (HiveProcessCommandType hiveProcessType : root.getHiveProcess()) {
            processConfiguration = this.createProcessConfiguration(hiveProcessType.getProcess());
            HiveProcessCommand command2 = new HiveProcessCommand(hiveProcessType.getId(), processConfiguration, hiveProcessType.getRestartDelay(), hiveProcessType.getMaxInputBuffer());
            hive.addContinuousCommand(command2);
        }
        for (TriggerCommandType triggerType : root.getTrigger()) {
            processConfiguration = this.createProcessConfiguration(triggerType.getProcess());
            boolean fork = triggerType.isSetFork() ? triggerType.isFork() : true;
            command = new TriggerCommand(triggerType.getId(), processConfiguration, this.createExtractors((List<ExtractorType>)triggerType.getExtractor(), hive), triggerType.getArgumentPlaceholder(), triggerType.isSkipIfNull(), fork);
            hive.addTrigger((TriggerCommand)command);
        }
        if (root.getAdditionalConfigurationDirectory() != null) {
            for (String directory : root.getAdditionalConfigurationDirectory()) {
                logger.info("Processing include dir: {}", (Object)directory);
                File dir = new File(directory);
                if (!dir.isDirectory()) {
                    logger.error("Unable to load configurations from directory: {}", (Object)dir);
                    continue;
                }
                File[] fileArray = dir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    logger.info("Found file: {}", (Object)file);
                    if (!file.isFile()) {
                        logger.warn("Is not a file. Skipping.");
                    } else if (!file.canRead()) {
                        logger.warn("Unable to read file. Skipping.");
                    } else {
                        this.processFile(file, hive);
                    }
                    ++n2;
                }
            }
        }
    }

    private RootType parse(URI uri) throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ConfigurationResourceFactoryImpl());
        Resource r = rs.createResource(uri);
        r.load(null);
        DocumentRoot doc = (DocumentRoot)EcoreUtil.getObjectByType((Collection)r.getContents(), (EClassifier)ConfigurationPackage.Literals.DOCUMENT_ROOT);
        if (doc == null) {
            return null;
        }
        return doc.getRoot();
    }

    private void processFile(File file, Hive hive) throws ConfigurationException {
        try {
            RootType subRoot = this.parse(URI.createFileURI((String)file.getAbsolutePath()));
            this.configure(subRoot, hive);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to parse sub xml document: " + file, e);
        }
    }

    private Splitter createSplitter(SplitterType splitterType) {
        String splitterTypeName = splitterType.getType();
        if ("newline".equals(splitterTypeName)) {
            return new SplitSplitter(System.getProperty("line.separator"));
        }
        if ("split".equals(splitterTypeName)) {
            return new SplitSplitter(splitterType.getParameter());
        }
        if ("regexpSplit".equals(splitterTypeName)) {
            return new RegExSplitSplitter(Pattern.compile(splitterType.getParameter()));
        }
        if ("regexpMatch".equals(splitterTypeName)) {
            return new RegExMatchSplitter(Pattern.compile(splitterType.getParameter()));
        }
        return null;
    }

    private void configureQueue(CommandQueue queue, QueueType queueType, Hive hive) throws ConfigurationException {
        for (SingleCommandType commandType : queueType.getCommand()) {
            SingleCommand command = this.createSingleCommand(commandType, hive);
            queue.addCommand(command, commandType.getPeriod());
        }
    }

    private SingleCommand createSingleCommand(SingleCommandType commandType, Hive hive) throws ConfigurationException {
        SingleCommandImpl command = new SingleCommandImpl(commandType.getId(), this.createProcessConfiguration(commandType.getProcess()), this.createExtractors((List<ExtractorType>)commandType.getExtractor(), hive));
        return command;
    }

    private Collection<Extractor> createExtractors(List<ExtractorType> extractorList, Hive hive) throws ConfigurationException {
        LinkedList<Extractor> result = new LinkedList<Extractor>();
        for (ExtractorType eType : extractorList) {
            result.add(this.createExtractor(eType, hive));
        }
        return result;
    }

    private Extractor createExtractor(ExtractorType type, Hive hive) throws ConfigurationException {
        if (type instanceof PlainStreamExtractorType) {
            return new PlainStreamExtractor(type.getName());
        }
        if (type instanceof RegExExtractorType) {
            RegExExtractorType regExType = (RegExExtractorType)type;
            boolean requireFullMatch = false;
            requireFullMatch = regExType.isRequireFullMatch();
            return new RegExExtractor(type.getName(), Pattern.compile(regExType.getExpression()), requireFullMatch, this.createFields(regExType));
        }
        if (type instanceof SplitterExtractorType) {
            SplitterExtractorType splitterType = (SplitterExtractorType)type;
            return new SplitterExtractor(type.getName(), splitterType.getSplitExpression(), this.createFields(splitterType));
        }
        if (type instanceof ReturnCodeExtractorType) {
            return new SimpleReturnCodeExtractor(type.getName());
        }
        if (type instanceof NagiosReturnCodeExtractorType) {
            return new NagiosExtractor(type.getName());
        }
        throw new ConfigurationException(String.format("Extractor of %s is unknown", type.getClass()));
    }

    private List<AbstractArrayExtractor.FieldMapping> createFields(FieldExtractorType regExType) {
        ArrayList<AbstractArrayExtractor.FieldMapping> groups = new ArrayList<AbstractArrayExtractor.FieldMapping>();
        for (FieldType group : regExType.getField()) {
            AbstractArrayExtractor.FieldMapping groupMapping = new AbstractArrayExtractor.FieldMapping();
            groupMapping.setName(group.getName());
            groupMapping.setType(AbstractArrayExtractor.FieldType.valueOf(group.getVariantType().toString()));
            groups.add(groupMapping);
        }
        return groups;
    }

    private ProcessConfiguration createProcessConfiguration(ProcessType process) {
        HashMap<String, String> env = null;
        if (process.getEnv() != null && !process.getEnv().isEmpty()) {
            env = new HashMap<String, String>();
            for (EnvEntryType entry : process.getEnv()) {
                if (entry.getName() == null || entry.getName().length() <= 0) continue;
                env.put(entry.getName(), entry.getValue());
            }
        }
        return new ProcessConfiguration(process.getExec(), (String[])process.getArgument().toArray((Object[])new String[0]), env);
    }
}

