/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.osgi.modbus;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.da.server.common.io.AbstractConnectionDevice;
import org.eclipse.scada.da.server.common.io.JobManager;
import org.eclipse.scada.da.server.osgi.modbus.ModbusSlave;
import org.eclipse.scada.protocol.modbus.codec.ModbusMasterProtocolFilter;
import org.eclipse.scada.protocol.modbus.codec.ModbusRtuDecoder;
import org.eclipse.scada.protocol.modbus.codec.ModbusRtuEncoder;
import org.eclipse.scada.protocol.modbus.codec.ModbusRtuProtocolCodecFilter;
import org.eclipse.scada.protocol.modbus.codec.ModbusTcpDecoder;
import org.eclipse.scada.protocol.modbus.codec.ModbusTcpEncoder;
import org.eclipse.scada.protocol.modbus.io.ChecksumProtocolException;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusMaster
extends AbstractConnectionDevice {
    private static final Logger logger = LoggerFactory.getLogger(ModbusMaster.class);
    private static final double INTER_FRAME_DELAY_DEFAULT = 1.75;
    private static final String TYPE_TCP = "TCP";
    private static final String TYPE_RTU = "RTU";
    private static final List<String> allowedModbusVariants = Arrays.asList("TCP", "RTU");
    private final Set<ModbusSlave> slaves = new CopyOnWriteArraySet<ModbusSlave>();
    private final JobManager jobManager;
    private String name;
    private int readTimeout;
    private double interFrameDelay = 1.75;
    private String protocolType = "TCP";

    public ModbusMaster(BundleContext context, String id, ScheduledExecutorService executor, NioProcessor processor, String threadPrefix, String itemPrefix) {
        super(context, id, processor, executor, itemPrefix);
        this.jobManager = new JobManager(executor);
    }

    public static ModbusMaster create(BundleContext context, ScheduledExecutorService executor, String id, NioProcessor processor, Map<String, String> parameters) throws Exception {
        ModbusMaster device = new ModbusMaster(context, id, executor, processor, "ModbusMaster", "modbus");
        device.configure(parameters);
        return device;
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    protected void configure(Map<String, String> properties) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        this.name = cfg.getString(this.name, this.id);
        this.readTimeout = ModbusMaster.getTimeout(properties, (String)"readTimeout", (int)10000);
        this.interFrameDelay = cfg.getDouble("interFrameDelay", Double.parseDouble(System.getProperty("org.eclipse.scada.da.server.osgi.modbus.defaultInterFrameDelay", "1.75")));
        this.protocolType = cfg.getStringOfChecked("protocolType", TYPE_TCP, allowedModbusVariants);
        super.configure(properties);
    }

    protected void configureConnector(NioSocketConnector connector) {
        logger.debug("Configuring connector: {}", (Object)connector);
        switch (this.protocolType) {
            case "TCP": {
                connector.getFilterChain().addLast("modbusPdu", (IoFilter)new ProtocolCodecFilter((ProtocolEncoder)new ModbusTcpEncoder(), (ProtocolDecoder)new ModbusTcpDecoder()));
                connector.getFilterChain().addLast("modbus", (IoFilter)new ModbusMasterProtocolFilter());
                break;
            }
            case "RTU": {
                ModbusRtuDecoder rtuDecoder = new ModbusRtuDecoder(this.getExecutor(), Double.valueOf(this.interFrameDelay * 1000.0).longValue(), TimeUnit.MICROSECONDS);
                connector.getFilterChain().addLast("modbusPdu", (IoFilter)new ModbusRtuProtocolCodecFilter((ProtocolEncoder)new ModbusRtuEncoder(), rtuDecoder));
                connector.getFilterChain().addLast("modbus", (IoFilter)new ModbusMasterProtocolFilter());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("'%s' is not an allowed modbus device type", this.protocolType));
            }
        }
        if (Boolean.getBoolean("org.eclipse.scada.da.server.osgi.modbus.trace")) {
            connector.getFilterChain().addFirst("logger", (IoFilter)new LoggingFilter(String.valueOf(ModbusMaster.class.getName()) + ".protocol"));
        }
    }

    public void addSlave(ModbusSlave slave) {
        logger.debug("Adding slave: {}", (Object)slave);
        if (this.slaves.add(slave)) {
            slave.start(this, this.jobManager);
        }
    }

    public void removeSlave(ModbusSlave slave) {
        logger.debug("Removing slave: {}", (Object)slave);
        if (this.slaves.remove(slave)) {
            slave.stop();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    protected synchronized void handleSessionCreated(IoSession session) throws Exception {
        super.handleSessionCreated(session);
        int timeout = this.readTimeout / 1000;
        session.getConfig().setIdleTime(IdleStatus.READER_IDLE, timeout);
        logger.debug("Setting timeout to {} seconds", (Object)timeout);
    }

    protected synchronized void handleSessionOpened(IoSession session) throws Exception {
        super.handleSessionOpened(session);
        this.jobManager.setSession(session);
    }

    protected synchronized void handleMessageReceived(IoSession session, Object message) throws Exception {
        super.handleMessageReceived(session, message);
        this.jobManager.messageReceived(message);
    }

    protected synchronized void handleExceptionCaught(IoSession session, Throwable error) throws Exception {
        if (error instanceof ChecksumProtocolException) {
            this.checkSession(session);
            logger.info("Checksum error", error);
            this.jobManager.handleException(error);
        } else {
            super.handleExceptionCaught(session, error);
        }
    }

    protected synchronized void handleSessionClosed(IoSession session) throws Exception {
        super.handleSessionClosed(session);
        this.jobManager.setSession(null);
    }
}

