/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.proxy.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Stack;
import org.eclipse.scada.da.client.FolderManager;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.core.browser.DataItemEntry;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.core.browser.FolderEntry;
import org.eclipse.scada.da.core.server.browser.NoSuchFolderException;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.browser.common.FolderListener;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.da.server.proxy.connection.ProxyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFolder
implements Folder,
org.eclipse.scada.da.client.FolderListener {
    private static final Logger logger = LoggerFactory.getLogger(ProxyFolder.class);
    private final FolderCommon folder = new FolderCommon();
    private final Location location;
    private boolean initialized = false;
    private final FolderManager folderManager;
    private final ProxyGroup proxyGroup;

    public ProxyFolder(FolderManager folderManager, ProxyGroup proxyGroup, Location location) {
        this.folderManager = folderManager;
        this.location = location;
        this.proxyGroup = proxyGroup;
    }

    public void added() {
        this.folder.added();
    }

    public Entry[] list(Stack<String> path) throws NoSuchFolderException {
        return this.folder.list(path);
    }

    public void removed() {
        this.checkDisconnect(true);
        this.folder.removed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDisconnect(boolean force) {
        ProxyFolder proxyFolder = this;
        synchronized (proxyFolder) {
            if (!this.initialized) {
                return;
            }
            if (!force && this.folder.hasSubscribers()) {
                return;
            }
            this.initialized = false;
            logger.info("Disconnect folder for location: {}", (Object)this.location);
        }
        this.folderManager.removeFolderListener((org.eclipse.scada.da.client.FolderListener)this, this.location);
        this.folder.clear();
    }

    public void subscribe(Stack<String> path, FolderListener listener, Object tag) throws NoSuchFolderException {
        this.connect();
        this.folder.subscribe(path, listener, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        ProxyFolder proxyFolder = this;
        synchronized (proxyFolder) {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
        }
        this.folderManager.addFolderListener((org.eclipse.scada.da.client.FolderListener)this, this.location);
    }

    public void unsubscribe(Stack<String> path, Object tag) throws NoSuchFolderException {
        this.folder.unsubscribe(path, tag);
        this.checkDisconnect(false);
    }

    public void folderChanged(Collection<Entry> added, Collection<String> removed, boolean full) {
        try {
            this.handleFolderChanged(added, removed, full);
        }
        catch (Throwable e) {
            logger.warn("Failed to handle folder change", e);
        }
    }

    private void handleFolderChanged(Collection<Entry> added, Collection<String> removed, boolean full) {
        if (full) {
            this.folder.clear();
        }
        for (String entry : removed) {
            this.folder.remove(entry);
        }
        HashMap<String, DataItemInformationBase> items = new HashMap<String, DataItemInformationBase>();
        HashMap<String, ProxyFolder> folders = new HashMap<String, ProxyFolder>();
        for (Entry entry : added) {
            if (entry instanceof DataItemEntry) {
                DataItemEntry dataItemEntry = (DataItemEntry)entry;
                String itemId = this.proxyGroup.convertToProxyId(dataItemEntry.getId());
                if (itemId == null) continue;
                DataItemInformationBase itemInformation = new DataItemInformationBase(itemId, dataItemEntry.getIODirections());
                items.put(entry.getName(), itemInformation);
                continue;
            }
            if (!(entry instanceof FolderEntry)) continue;
            ArrayList<String> location = new ArrayList<String>(this.location.asList());
            location.add(entry.getName());
            folders.put(entry.getName(), new ProxyFolder(this.folderManager, this.proxyGroup, new Location(location)));
        }
        this.folder.add(folders, items);
    }
}

