/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.osgi.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.sec.AuthorizationRequest;
import org.eclipse.scada.sec.AuthorizationResult;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.eclipse.scada.sec.authz.AuthorizationRule;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.script.ScriptExecutor;
import org.eclipse.scada.utils.script.Scripts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseRule
implements AuthorizationRule {
    private static final InstantFuture<AuthorizationResult> ABSTAIN_FUTURE = new InstantFuture(null);
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseRule.class);
    private Pattern objectId;
    private Pattern objectType;
    private Pattern action;
    private final ScriptEngineManager engineManager = Scripts.createManager((ClassLoader)AbstractBaseRule.class.getClassLoader());
    private ScriptExecutor scriptFilter;

    public void dispose() {
    }

    public void setPreFilter(Map<String, String> properties) throws Exception {
        String script;
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        if (properties != null) {
            this.setPreFilter(properties.get("for.id"), properties.get("for.type"), properties.get("for.action"));
        }
        if ((script = properties.get("filter.script")) != null && !script.isEmpty()) {
            this.scriptFilter = new ScriptExecutor(this.engineManager, cfg.getString("filter.script.engine", "JavaScript"), script, AbstractBaseRule.class.getClassLoader());
        }
    }

    protected void setPreFilter(String idFilter, String typeFilter, String actionFilter) {
        this.objectId = idFilter != null ? Pattern.compile(idFilter) : null;
        this.objectType = typeFilter != null ? Pattern.compile(typeFilter) : null;
        this.action = actionFilter != null ? Pattern.compile(actionFilter) : null;
    }

    public NotifyFuture<AuthorizationResult> authorize(AuthorizationContext context) {
        AuthorizationRequest request = context.getRequest();
        logger.debug("Checking authentication - objectType: {}, objectId: {}, action: {}, user: {}, context: {}", new Object[]{request.getObjectType(), request.getObjectId(), request.getAction(), request.getUserInformation(), request.getContext()});
        logger.debug("Pre-Filter - objectType: {}, objectId: {}, action: {}", new Object[]{this.objectType, this.objectId, this.action});
        if (request != null && request.getObjectId() != null && this.objectId != null && !this.objectId.matcher(request.getObjectId()).matches()) {
            return ABSTAIN_FUTURE;
        }
        if (request != null && request.getObjectType() != null && this.objectType != null && !this.objectType.matcher(request.getObjectType()).matches()) {
            return ABSTAIN_FUTURE;
        }
        if (request != null && request.getAction() != null && this.action != null && !this.action.matcher(request.getAction()).matches()) {
            return ABSTAIN_FUTURE;
        }
        try {
            if (this.scriptFilter != null && this.matchesScriptFilter(context)) {
                return ABSTAIN_FUTURE;
            }
        }
        catch (Exception e) {
            return new InstantErrorFuture((Throwable)e);
        }
        return this.procesAuthorize(context);
    }

    private boolean matchesScriptFilter(AuthorizationContext context) throws Exception {
        logger.debug("Running script filter for request: {}", (Object)context);
        SimpleScriptContext ctx = new SimpleScriptContext();
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("authorizationContext", context);
        bindings.put("request", context.getRequest());
        return this.processResult(this.scriptFilter.execute((ScriptContext)ctx, bindings));
    }

    private boolean processResult(Object execute) {
        logger.debug("Processing filter result: {}", execute);
        if (execute == null) {
            return false;
        }
        if (execute instanceof Boolean) {
            return (Boolean)execute;
        }
        if (execute instanceof Number) {
            return ((Number)execute).intValue() != 0;
        }
        return Boolean.parseBoolean(execute.toString());
    }

    protected abstract NotifyFuture<AuthorizationResult> procesAuthorize(AuthorizationContext var1);

    public Pattern getActionFilter() {
        return this.action;
    }

    public Pattern getIdFilter() {
        return this.objectId;
    }

    public Pattern getTypeFilter() {
        return this.objectType;
    }

    public ScriptExecutor getScriptFilter() {
        return this.scriptFilter;
    }
}

