/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.osgi.manager;

import org.eclipse.scada.sec.AuthorizationReply;
import org.eclipse.scada.sec.AuthorizationRequest;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.eclipse.scada.sec.osgi.AuthorizationTracker;
import org.eclipse.scada.sec.osgi.manager.AuthorizationManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorImpl
implements AuthorizationTracker.Monitor {
    private static final Logger logger = LoggerFactory.getLogger(MonitorImpl.class);
    private final AuthorizationManagerImpl authorizationManagerImpl;
    private volatile AuthorizationTracker.Listener listener;
    private AuthorizationReply lastResult;
    private final AuthorizationContext context;

    public MonitorImpl(AuthorizationManagerImpl authorizationManagerImpl, AuthorizationTracker.Listener listener, AuthorizationRequest request) {
        this.authorizationManagerImpl = authorizationManagerImpl;
        this.listener = listener;
        this.context = new AuthorizationContext();
        this.context.setRequest(request);
    }

    public void dispose() {
        logger.debug("Dispose monitor");
        this.listener = null;
        this.authorizationManagerImpl.disposeMonitor(this);
    }

    public void setResult(AuthorizationReply result) {
        AuthorizationTracker.Listener listener = this.listener;
        if (listener != null) {
            if (this.lastResult != null && this.lastResult.equals(result)) {
                return;
            }
            this.lastResult = result;
            logger.debug("Updating result - {}", (Object)result);
            try {
                listener.resultChanged(result);
            }
            catch (Exception e) {
                logger.warn("Failed to notify listener", (Throwable)e);
            }
        }
    }

    public AuthorizationContext getContext() {
        return this.context;
    }
}

