/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.firewall;

import java.net.Inet4Address;
import java.net.InetAddress;

public class Subnet {
    private static final int IP_MASK = Integer.MIN_VALUE;
    private static final int BYTE_MASK = 255;
    private InetAddress subnet;
    private int subnetInt;
    private int subnetMask;
    private int suffix;

    public Subnet(InetAddress subnet, int mask) {
        if (subnet == null) {
            throw new IllegalArgumentException("Subnet address can not be null");
        }
        if (!(subnet instanceof Inet4Address)) {
            throw new IllegalArgumentException("Only IPv4 supported");
        }
        if (mask < 0 || mask > 32) {
            throw new IllegalArgumentException("Mask has to be an integer between 0 and 32");
        }
        this.subnet = subnet;
        this.subnetInt = this.toInt(subnet);
        this.suffix = mask;
        this.subnetMask = Integer.MIN_VALUE >> mask - 1;
    }

    private int toInt(InetAddress inetAddress) {
        byte[] address = inetAddress.getAddress();
        int result = 0;
        int i = 0;
        while (i < address.length) {
            result <<= 8;
            result |= address[i] & 0xFF;
            ++i;
        }
        return result;
    }

    private int toSubnet(InetAddress address) {
        return this.toInt(address) & this.subnetMask;
    }

    public boolean inSubnet(InetAddress address) {
        return this.toSubnet(address) == this.subnetInt;
    }

    public String toString() {
        return String.valueOf(this.subnet.getHostAddress()) + "/" + this.suffix;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        return other.subnetInt == this.subnetInt && other.suffix == this.suffix;
    }
}

