/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.logging;

import java.lang.reflect.Method;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.paho.client.mqttv3.logging.Logger;

public class LoggerFactory {
    public static final String MQTT_CLIENT_MSG_CAT = "org.eclipse.paho.client.mqttv3.internal.nls.logcat";
    private static final String CLASS_NAME;
    private static String overrideloggerClassName;
    private static String jsr47LoggerClassName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.paho.client.mqttv3.logging.LoggerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
        overrideloggerClassName = null;
        jsr47LoggerClassName = "org.eclipse.paho.client.mqttv3.logging.JSR47Logger";
    }

    public static Logger getLogger(String messageCatalogName, String loggerID) {
        String loggerClassName = overrideloggerClassName;
        Logger logger = null;
        if (loggerClassName == null) {
            loggerClassName = jsr47LoggerClassName;
        }
        if ((logger = LoggerFactory.getLogger(loggerClassName, ResourceBundle.getBundle(messageCatalogName), loggerID, null)) == null) {
            throw new MissingResourceException("Error locating the logging class", CLASS_NAME, loggerID);
        }
        return logger;
    }

    private static Logger getLogger(String loggerClassName, ResourceBundle messageCatalog, String loggerID, String resourceName) {
        Logger logger = null;
        Class<?> logClass = null;
        try {
            logClass = Class.forName(loggerClassName);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        if (logClass != null) {
            try {
                logger = (Logger)logClass.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                return null;
            }
            catch (SecurityException securityException) {
                return null;
            }
            logger.initialise(messageCatalog, loggerID, resourceName);
        }
        return logger;
    }

    public static String getLoggingProperty(String name) {
        String result = null;
        try {
            Class<?> logManagerClass = Class.forName("java.util.logging.LogManager");
            Method m1 = logManagerClass.getMethod("getLogManager", new Class[0]);
            Object logManagerInstance = m1.invoke(null, null);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method m2 = logManagerClass.getMethod("getProperty", classArray);
            result = (String)m2.invoke(logManagerInstance, name);
        }
        catch (Exception exception) {
            result = null;
        }
        return result;
    }

    public static void setLogger(String loggerClassName) {
        overrideloggerClassName = loggerClassName;
    }
}

