/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.login.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.scada.core.ui.connection.login.LoginContext;
import org.eclipse.scada.core.ui.connection.login.LoginFactory;
import org.eclipse.scada.core.ui.connection.login.LoginHandler;
import org.eclipse.scada.core.ui.connection.login.StateListener;
import org.eclipse.scada.core.ui.connection.login.dialog.ContextCreatorListener;
import org.eclipse.scada.core.ui.connection.login.dialog.ContextCreatorResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextCreator {
    private static final Logger logger = LoggerFactory.getLogger(ContextCreator.class);
    private final LoginContext context;
    private final ContextCreatorListener listener;
    private final Realm realm;
    private final Set<LoginHandler> handlers = new HashSet<LoginHandler>();
    private final ContextCreatorResultListener resultListener;
    private boolean complete = false;

    public ContextCreator(Realm realm, LoginContext loginContext, ContextCreatorListener listener, ContextCreatorResultListener resultListener) {
        this.realm = realm;
        this.context = loginContext;
        this.listener = listener;
        this.resultListener = resultListener;
    }

    /*
     * Unable to fully structure code
     */
    public void start(String username, String password, Map<String, String> properties) {
        for (LoginFactory factory : this.context.getFactories()) {
            try {
                handler = factory.createHandler(this.context, username, password, properties);
                if (handler == null) {
                    this.notifyStateChange(factory.getClass().getName(), "MISSING", null);
                    continue;
                }
                handler.setStateListener(new StateListener(){

                    @Override
                    public void stateChanged(String connectionName, String state, Throwable error) {
                        ContextCreator.this.handleStateChange(handler, connectionName, state, error);
                    }
                });
                this.handlers.add(handler);
                continue;
            }
            catch (Throwable e) {
                ContextCreator.logger.warn("Failed to start logon", e);
                ** for (handler : this.handlers)
            }
lbl-1000:
            // 1 sources

            {
                handler.dispose();
                continue;
            }
lbl16:
            // 1 sources

            this.handlers.clear();
            this.notifyStateChange(factory.getClass().getName(), "FAILED", e);
        }
        if (this.handlers.size() != this.context.getFactories().size()) {
            for (LoginHandler handler : this.handlers) {
                handler.dispose();
            }
            this.handlers.clear();
            this.notifyResult(null);
        } else {
            for (LoginHandler handler : this.handlers) {
                handler.startLogin();
            }
        }
    }

    protected synchronized void handleStateChange(LoginHandler handler, String connectionName, String state, Throwable error) {
        this.notifyStateChange(connectionName, state, error);
        if (this.isComplete()) {
            this.notifyResult((Collection<LoginHandler>)(this.allOk() ? new ArrayList<LoginHandler>(this.handlers) : null));
        }
    }

    private boolean isComplete() {
        logger.debug("Check complete");
        logger.debug("Handlers: {}", this.handlers);
        for (LoginHandler handler : this.handlers) {
            if (handler.isComplete()) continue;
            return false;
        }
        return true;
    }

    private boolean allOk() {
        for (LoginHandler handler : this.handlers) {
            if (handler.isOk()) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        if (!this.complete) {
            this.notifyResult(null);
        }
        for (LoginHandler handler : this.handlers) {
            handler.dispose();
        }
        this.handlers.clear();
    }

    private void notifyStateChange(final String handlerName, final String state, final Throwable error) {
        if (this.listener != null && handlerName != null) {
            logger.info("Fire state change - connection: {}, state: {}, error: {}", new Object[]{handlerName, state, error});
            this.realm.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ContextCreator.this.listener.stateChanged(handlerName, state, error);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyResult(final Collection<LoginHandler> result) {
        ContextCreator contextCreator = this;
        synchronized (contextCreator) {
            if (this.complete) {
                logger.warn("Somehow we wanted to send the result twice. Skipping!");
                return;
            }
            this.complete = true;
        }
        for (LoginHandler handler : this.handlers) {
            handler.setStateListener(null);
        }
        if (this.resultListener == null) {
            return;
        }
        if (result != null) {
            this.handlers.clear();
        }
        this.realm.asyncExec(new Runnable(){

            @Override
            public void run() {
                ContextCreator.this.resultListener.complete(result);
            }
        });
    }
}

