/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.event.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.event.EventListener;
import org.eclipse.scada.ae.event.EventManager;
import org.eclipse.scada.ae.event.EventService;
import org.eclipse.scada.ae.server.storage.Storage;
import org.eclipse.scada.ae.server.storage.StoreListener;
import org.eclipse.scada.utils.osgi.FilterUtil;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventServiceImpl
implements EventService,
EventManager {
    private static final Logger logger = LoggerFactory.getLogger(EventServiceImpl.class);
    private final BundleContext context;
    private final SingleServiceTracker<Storage> storageTracker;
    private final List<Event> writeQueue = new LinkedList<Event>();
    private final List<Event> eventBuffer = new LinkedList<Event>();
    private final Set<EventListener> listeners = new HashSet<EventListener>();
    private Storage storage;
    private final StoreListener storeListener;

    public EventServiceImpl(BundleContext context) throws InvalidSyntaxException {
        this.context = context;
        this.storeListener = new StoreListener(){

            public void notify(Event event) {
                EventServiceImpl.this.eventStored(event);
            }
        };
        Filter filter = FilterUtil.createClassFilter((String)Storage.class.getName());
        this.storageTracker = new SingleServiceTracker(this.context, filter, (SingleServiceListener)new SingleServiceListener<Storage>(){

            public void serviceChange(ServiceReference<Storage> reference, Storage service) {
                EventServiceImpl.this.setStorage(service);
            }
        });
        this.storageTracker.open();
    }

    protected synchronized void eventStored(Event event) {
        this.writeQueue.remove(event);
        logger.debug("Write queue size - after event: {}", (Object)this.writeQueue.size());
    }

    public void dispose() {
        this.storageTracker.close();
    }

    protected synchronized void setStorage(Storage service) {
        this.storage = service;
        this.writeQueue.clear();
        this.publishBufferedEvents();
    }

    private void publishBufferedEvents() {
        logger.info("Storing {} recorded events", (Object)this.eventBuffer.size());
        for (Event event : this.eventBuffer) {
            this.performStore(event);
        }
        this.eventBuffer.clear();
    }

    @Override
    public synchronized void publishEvent(Event event) {
        if (this.storage != null) {
            this.performStore(event);
        } else {
            this.eventBuffer.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performStore(Event event) {
        Event storedEvent;
        EventServiceImpl eventServiceImpl = this;
        synchronized (eventServiceImpl) {
            storedEvent = this.storage.store(event, this.storeListener);
            this.writeQueue.add(storedEvent);
        }
        logger.debug("Write queue size - after store: {}", (Object)this.writeQueue.size());
        for (EventListener listener : this.listeners) {
            try {
                listener.handleEvent(Arrays.asList(storedEvent));
            }
            catch (Exception e) {
                logger.info("Failed to handle listener", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void addEventListener(EventListener listener) {
        if (this.listeners.add(listener)) {
            listener.handleEvent(Collections.unmodifiableList(this.writeQueue));
        }
    }

    @Override
    public synchronized void removeEventListener(EventListener listener) {
        this.listeners.remove(listener);
    }
}

