/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.protocol.ngp.codec.impl;

import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.ae.data.EventInformation;
import org.eclipse.scada.ae.protocol.ngp.codec.Structures;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateQueryData
implements BinaryMessageCodec {
    private static final Logger logger = LoggerFactory.getLogger(UpdateQueryData.class);
    public static final int MESSAGE_CODE = 8709;

    public int getMessageCode() {
        return 8709;
    }

    public Class<?> getMessageClass() {
        return org.eclipse.scada.ae.data.message.UpdateQueryData.class;
    }

    public org.eclipse.scada.ae.data.message.UpdateQueryData decodeMessage(BinaryContext _context, IoBuffer _data) throws Exception {
        int messageCode = _data.getInt();
        if (messageCode != 8709) {
            throw new IllegalStateException(String.format("Expected messageCode %s but found %s", 8709, messageCode));
        }
        int numberOfFields = _data.get();
        long queryId = 0L;
        List<EventInformation> events = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    queryId = _context.decodePrimitiveLong(_data);
                    break;
                }
                case 2: {
                    events = Structures.decodeListEventInformation(_context, _data, true);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new org.eclipse.scada.ae.data.message.UpdateQueryData(queryId, events);
    }

    public IoBuffer encodeMessage(BinaryContext context, Object objectMessage) throws Exception {
        org.eclipse.scada.ae.data.message.UpdateQueryData value = (org.eclipse.scada.ae.data.message.UpdateQueryData)objectMessage;
        IoBuffer data = IoBuffer.allocate((int)64);
        data.setAutoExpand(true);
        data.putInt(8709);
        data.put((byte)2);
        context.encodePrimitiveLong(data, (byte)1, value.getQueryId());
        Structures.encodeCollectionEventInformation(context, data, (byte)2, value.getEvents());
        data.flip();
        return data;
    }
}

