/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage.postgres;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.UUID;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;

public class EventConverter {
    private static final String isoDatePatterrn = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss.SSS").serializeNulls().serializeSpecialFloatingPointValues().registerTypeAdapter(Variant.class, (Object)new VariantSerializer()).registerTypeAdapter(Variant.class, (Object)new VariantDeserializer()).create();
    public static final EventConverter INSTANCE = new EventConverter();

    private EventConverter() {
    }

    public Event toEvent(String json) {
        return (Event)gson.fromJson(json, Event.class);
    }

    public String toJson(Event event) {
        return gson.toJson((Object)event);
    }

    public Array toSqlArray(Connection connection, Event event) throws SQLException {
        SimpleDateFormat isoDateFormat = new SimpleDateFormat(isoDatePatterrn);
        Object[] fields = new String[(event.getAttributes().size() + 3) * 2];
        fields[0] = "id";
        fields[1] = event.getId().toString();
        fields[2] = "sourceTimestamp";
        fields[3] = isoDateFormat.format(event.getSourceTimestamp());
        fields[4] = "entryTimestamp";
        fields[5] = isoDateFormat.format(event.getEntryTimestamp());
        int i = 6;
        for (Map.Entry entry : event.getAttributes().entrySet()) {
            fields[i] = (String)entry.getKey();
            fields[i + 1] = ((Variant)entry.getValue()).toString();
            i += 2;
        }
        return connection.createArrayOf("text", fields);
    }

    public Event fromSqlArray(Array array) throws SQLException, ParseException {
        SimpleDateFormat isoDateFormat = new SimpleDateFormat(isoDatePatterrn);
        Event.EventBuilder eb = Event.create();
        String[] fields = (String[])array.getArray();
        int i = 0;
        while (i < fields.length) {
            String key = fields[i];
            String value = fields[i + 1];
            if (key.equals("id")) {
                eb.id(UUID.fromString(value));
            } else if (key.equals("sourceTimestamp")) {
                eb.sourceTimestamp(isoDateFormat.parse(value));
            } else if (key.equals("entryTimestamp")) {
                eb.entryTimestamp(isoDateFormat.parse(value));
            } else {
                eb.attribute(key, VariantEditor.toVariant((String)value));
            }
            i += 2;
        }
        return eb.build();
    }

    private static class VariantDeserializer
    implements JsonDeserializer<Variant> {
        private VariantDeserializer() {
        }

        public Variant deserialize(JsonElement jsonElement, Type typeOfDst, JsonDeserializationContext context) throws JsonParseException {
            return VariantEditor.toVariant((String)jsonElement.getAsString());
        }
    }

    private static class VariantSerializer
    implements JsonSerializer<Variant> {
        private VariantSerializer() {
        }

        public JsonElement serialize(Variant src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }
}

