/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.connection.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.ae.BrowserListener;
import org.eclipse.scada.ae.connection.provider.ConnectionService;
import org.eclipse.scada.ae.data.BrowserEntry;
import org.eclipse.scada.ae.ui.connection.data.BrowserEntryBean;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionWrapper
extends WritableSet
implements PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionWrapper.class);
    private final ConnectionHolder holder;
    private ConnectionService service;
    private final Map<String, BrowserEntryBean> entries = new HashMap<String, BrowserEntryBean>();
    private BrowserListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionWrapper(ConnectionHolder target) {
        this.holder = target;
        ConnectionWrapper connectionWrapper = this;
        synchronized (connectionWrapper) {
            this.holder.addPropertyChangeListener("connectionService", (PropertyChangeListener)this);
            this.triggerUpdate();
        }
    }

    public synchronized void dispose() {
        this.holder.removePropertyChangeListener("connectionService", (PropertyChangeListener)this);
        super.dispose();
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        this.triggerUpdate();
    }

    private void triggerUpdate() {
        this.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConnectionWrapper.this.update();
            }
        });
    }

    private void update() {
        this.setStale(true);
        try {
            ConnectionService service;
            this.clearConnection();
            this.service = service = (ConnectionService)this.holder.getConnectionService();
            if (this.service != null) {
                this.setupConnection();
            }
        }
        finally {
            this.setStale(false);
        }
    }

    private void setupConnection() {
        this.listener = new BrowserListener(){

            public void dataChanged(List<BrowserEntry> addedOrUpdated, Set<String> removed, boolean full) {
                ConnectionWrapper.this.dataChanged(addedOrUpdated, removed, full);
            }
        };
        this.service.getConnection().addBrowserListener(this.listener);
    }

    private void clearConnection() {
        this.clear();
        for (BrowserEntryBean entry : this.entries.values()) {
            entry.dispose();
        }
        if (this.service != null) {
            this.service.getConnection().removeBrowserListener(this.listener);
        }
        this.listener = null;
        this.entries.clear();
        this.service = null;
    }

    public ConnectionService getService() {
        return this.service;
    }

    public void dataChanged(final List<BrowserEntry> addedOrUpdated, final Set<String> removed, final boolean full) {
        this.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConnectionWrapper.this.handleDataChanged(addedOrUpdated, removed, full);
            }
        });
    }

    protected void handleDataChanged(List<BrowserEntry> addedOrUpdated, Set<String> removed, boolean full) {
        if (this.isDisposed()) {
            return;
        }
        this.setStale(true);
        try {
            if (full) {
                this.clear();
            }
            if (removed != null) {
                for (String item : removed) {
                    BrowserEntryBean entry = this.entries.remove(item);
                    if (entry == null) continue;
                    logger.debug("Removing: {}", (Object)entry);
                    this.remove(entry);
                    entry.dispose();
                }
            }
            if (addedOrUpdated != null) {
                for (BrowserEntry entry : addedOrUpdated) {
                    BrowserEntryBean newEntry = new BrowserEntryBean(this.service, entry);
                    BrowserEntryBean oldEntry = this.entries.put(entry.getId(), newEntry);
                    if (oldEntry != null) {
                        logger.debug("Removing old: {}", (Object)entry.getId());
                        this.remove(oldEntry);
                        oldEntry.dispose();
                    }
                    logger.debug("Adding: {}", (Object)entry.getId());
                    this.add(newEntry);
                }
            }
        }
        finally {
            this.setStale(false);
        }
    }
}

