/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.filter;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scada.ae.filter.EventMatcher;
import org.eclipse.scada.ae.filter.internal.EventMatcherImpl;
import org.eclipse.scada.ae.ui.views.model.DecoratedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventViewerFilter
extends ViewerFilter {
    private static final Logger logger = LoggerFactory.getLogger(EventViewerFilter.class);
    private final EventMatcher eventMatcher;
    private final String filter;

    public EventViewerFilter(String filter) {
        this.filter = filter;
        this.eventMatcher = new EventMatcherImpl(filter);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.eventMatcher == null) {
            return true;
        }
        if (!(element instanceof DecoratedEvent)) {
            return false;
        }
        try {
            return this.eventMatcher.matches(((DecoratedEvent)element).getEvent());
        }
        catch (Exception e) {
            logger.warn("Failed to filter", (Throwable)e);
            return false;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EventViewerFilter other = (EventViewerFilter)((Object)obj);
        return !(this.filter == null ? other.filter != null : !this.filter.equals(other.filter));
    }

    public String toString() {
        return "EventViewerFilter [filter=" + this.filter + "]";
    }
}

