/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.jdbc.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.scada.ca.jdbc.internal.Entry;
import org.eclipse.scada.ca.jdbc.internal.JdbcStorageDAO;
import org.eclipse.scada.utils.osgi.jdbc.CommonConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapper;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapperAdapter;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapperMappingException;
import org.eclipse.scada.utils.osgi.jdbc.pool.PoolConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.task.CommonConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionContext;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionTask;
import org.osgi.service.jdbc.DataSourceFactory;

public class JdbcStorageDAOImpl
implements JdbcStorageDAO {
    private static final String defaultOrder = " ORDER BY instance_id, factory_id, configuration_id, chunk_seq";
    private final String tableName = JdbcStorageDAOImpl.getTableName();
    private final int chunkSize = JdbcStorageDAOImpl.getChunkSize();
    private final boolean fixNull = JdbcStorageDAOImpl.isFixNull();
    private final String instanceId = JdbcStorageDAOImpl.getInstanceId();
    private final RowMapper<Entry> mapper = new RowMapperAdapter<Entry>(){

        public Entry mapRow(ResultSet rs) throws SQLException {
            Entry entry = new Entry();
            entry.setInstance(rs.getString("instance_id"));
            entry.setFactoryId(rs.getString("factory_id"));
            entry.setConfigurationId(rs.getString("configuration_id"));
            entry.setKey(rs.getString("ca_key"));
            entry.setValue(rs.getString("ca_value"));
            entry.setSeq(rs.getInt("chunk_seq"));
            return entry;
        }
    };
    private final CommonConnectionAccessor accessor;

    public JdbcStorageDAOImpl(DataSourceFactory dataSourceFactory, Properties dataSourceProperties, boolean usePool) throws SQLException {
        this.accessor = usePool ? new PoolConnectionAccessor(dataSourceFactory, dataSourceProperties) : new DataSourceConnectionAccessor(dataSourceFactory, dataSourceProperties);
    }

    public void dispose() {
        this.accessor.dispose();
    }

    protected List<Entry> internalLoad(ConnectionContext connectionContext, String sql, Object ... parameters) throws SQLException {
        return this.deChunk(this.fixNulls(connectionContext.query(this.mapper, sql, parameters)));
    }

    protected List<Entry> load(final String sql, final Object ... parameters) {
        List result = (List)this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<List<Entry>>(){

            protected List<Entry> performTask(ConnectionContext connectionContext) throws Exception {
                return connectionContext.query(JdbcStorageDAOImpl.this.mapper, sql, parameters);
            }
        });
        return this.deChunk(this.fixNulls(result));
    }

    @Override
    public List<Entry> loadAll() {
        return this.load(String.format("SELECT * FROM %s WHERE instance_id = ? %s", this.tableName, defaultOrder), this.instanceId);
    }

    @Override
    public List<Entry> loadFactory(String factoryId) {
        return this.load(String.format("SELECT * FROM %s WHERE instance_id = ? AND factory_id = ? %s", this.tableName, defaultOrder), this.instanceId, factoryId);
    }

    @Override
    public List<String> listFactories() {
        final String sql = String.format("SELECT DISTINCT factory_id FROM %s WHERE instance_id = ?", this.tableName);
        return (List)this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<List<String>>(){

            protected List<String> performTask(ConnectionContext connectionContext) throws Exception {
                return connectionContext.query((RowMapper)new RowMapperAdapter<String>(){

                    public String mapRow(ResultSet resultSet) throws SQLException, RowMapperMappingException {
                        return resultSet.getString(1);
                    }
                }, sql, new Object[]{JdbcStorageDAOImpl.this.instanceId});
            }
        });
    }

    private List<Entry> loadConfiguration(ConnectionContext connectionContext, String factoryId, String configurationId) throws SQLException {
        return this.internalLoad(connectionContext, String.format("SELECT * FROM %s WHERE instance_id = ?  AND factory_id = ? AND configuration_id = ? %s", this.tableName, defaultOrder), this.instanceId, factoryId, configurationId);
    }

    @Override
    public Map<String, String> storeConfiguration(final String factoryId, final String configurationId, final Map<String, String> properties, final boolean fullSet) {
        return (Map)this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Map<String, String>>(){

            protected Map<String, String> performTask(ConnectionContext connectionContext) throws Exception {
                connectionContext.setAutoCommit(false);
                Map<String, String> result = JdbcStorageDAOImpl.this.internalStoreConfiguration(connectionContext, factoryId, configurationId, properties, fullSet);
                connectionContext.commit();
                return result;
            }
        });
    }

    protected Map<String, String> internalStoreConfiguration(ConnectionContext connectionContext, String factoryId, String configurationId, Map<String, String> properties, boolean fullSet) throws SQLException {
        if (fullSet) {
            this.internalDeleteConfiguration(connectionContext, factoryId, configurationId);
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        ArrayList<Entry> toStore = new ArrayList<Entry>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getValue() != null) {
                Entry dataEntry = new Entry();
                dataEntry.setInstance(this.instanceId);
                dataEntry.setFactoryId(factoryId);
                dataEntry.setConfigurationId(configurationId);
                dataEntry.setKey(entry.getKey());
                dataEntry.setValue(entry.getValue());
                toStore.add(dataEntry);
            }
            keys.add(entry.getKey());
        }
        if (!keys.isEmpty()) {
            Object[] objectArray = new Object[3 + keys.size()];
            objectArray[0] = this.instanceId;
            objectArray[1] = factoryId;
            objectArray[2] = configurationId;
            int i = 3;
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                objectArray[i] = iter.next();
                ++i;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("DELETE FROM ").append(this.tableName).append(" WHERE instance_id = ? AND factory_id = ? AND configuration_id = ? and ca_key in (");
            int i2 = 0;
            while (i2 < keys.size()) {
                sb.append(i2 == 0 ? "?" : ", ?");
                ++i2;
            }
            sb.append(")");
            connectionContext.update(sb.toString(), objectArray);
        }
        for (Entry entry : this.chunk(toStore)) {
            this.storeEntry(connectionContext, entry);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        for (Entry entry : this.loadConfiguration(connectionContext, factoryId, configurationId)) {
            if (entry.getKey() != null) {
                hashMap.put(entry.getKey().intern(), entry.getValue());
                continue;
            }
            hashMap.put(null, entry.getValue());
        }
        return hashMap;
    }

    private void storeEntry(ConnectionContext connectionContext, Entry entry) throws SQLException {
        Object[] params = new Object[]{entry.getInstance(), entry.getFactoryId(), entry.getConfigurationId(), entry.getKey(), entry.getValue(), entry.getSeq()};
        connectionContext.update(String.format("INSERT INTO %s (instance_id, factory_id, configuration_id, ca_key, ca_value, chunk_seq) VALUES (?, ?, ?, ?, ?, ?)", this.tableName), params);
    }

    @Override
    public List<Entry> purgeFactory(final String factoryId) {
        List<Entry> entries = this.fixNulls(this.loadFactory(factoryId));
        this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Void>(){

            protected Void performTask(ConnectionContext connectionContext) throws Exception {
                connectionContext.update(String.format("DELETE FROM %s WHERE instance_id = ? AND factory_id = ?", JdbcStorageDAOImpl.this.tableName), new Object[]{JdbcStorageDAOImpl.this.instanceId, factoryId});
                return null;
            }
        });
        return entries;
    }

    @Override
    public void deleteConfiguration(final String factoryId, final String configurationId) {
        this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Void>(){

            protected Void performTask(ConnectionContext connectionContext) throws Exception {
                connectionContext.setAutoCommit(false);
                JdbcStorageDAOImpl.this.internalDeleteConfiguration(connectionContext, factoryId, configurationId);
                connectionContext.commit();
                return null;
            }
        });
    }

    protected void internalDeleteConfiguration(ConnectionContext connectionContext, String factoryId, String configurationId) throws SQLException {
        connectionContext.update(String.format("DELETE FROM %s WHERE instance_id = ? AND factory_id = ? AND configuration_id = ?", this.tableName), new Object[]{this.instanceId, factoryId, configurationId});
    }

    protected List<Entry> fixNulls(List<Entry> data) {
        if (!this.fixNull) {
            return data;
        }
        for (Entry entry : data) {
            if (entry.getValue() != null) continue;
            entry.setValue("");
        }
        return data;
    }

    protected List<Entry> chunk(List<Entry> data) {
        if (this.chunkSize == 0) {
            return data;
        }
        ArrayList<Entry> result = new ArrayList<Entry>();
        for (Entry entry : data) {
            if (entry.getValue() == null || entry.getValue().length() <= this.chunkSize) {
                result.add(entry);
                continue;
            }
            int from = 0;
            int to = this.chunkSize;
            int seq = 1;
            do {
                if (to > entry.getValue().length()) {
                    to = entry.getValue().length();
                }
                Entry newEntry = new Entry(entry);
                newEntry.setValue(entry.getValue().substring(from, to));
                newEntry.setSeq(seq);
                result.add(newEntry);
                to += this.chunkSize;
                ++seq;
            } while ((from += this.chunkSize) < entry.getValue().length());
        }
        return result;
    }

    protected List<Entry> deChunk(List<Entry> data) {
        ArrayList<Entry> result = new ArrayList<Entry>();
        Entry newEntry = new Entry();
        for (Entry entry : data) {
            if (entry.getSeq() == 0) {
                if (newEntry.getSeq() > 0) {
                    newEntry.setSeq(0);
                    result.add(newEntry);
                    newEntry = new Entry();
                }
                result.add(entry);
                continue;
            }
            newEntry.setInstance(entry.getInstance());
            newEntry.setFactoryId(entry.getFactoryId());
            newEntry.setConfigurationId(entry.getConfigurationId());
            newEntry.setKey(entry.getKey());
            newEntry.setValue(String.valueOf(newEntry.getValue() == null ? "" : newEntry.getValue()) + entry.getValue());
            newEntry.setSeq(entry.getSeq());
        }
        if (newEntry.getSeq() > 0) {
            newEntry.setSeq(0);
            result.add(newEntry);
        }
        return result;
    }

    private static String getTableName() {
        return System.getProperty("org.eclipse.scada.ca.jdbc.table", "ca_data");
    }

    private static int getChunkSize() {
        return Integer.getInteger("org.eclipse.scada.ca.jdbc.chunksize", 0);
    }

    private static boolean isFixNull() {
        return Boolean.getBoolean("org.eclipse.scada.ca.jdbc.fixnull");
    }

    private static String getInstanceId() {
        return System.getProperty("org.eclipse.scada.ca.jdbc.instance", "default");
    }
}

