/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.arduino;

import java.util.Map;
import org.eclipse.scada.configuration.arduino.ArduinoConnection;
import org.eclipse.scada.configuration.arduino.ArduinoDevice;
import org.eclipse.scada.configuration.arduino.ArduinoDriver;
import org.eclipse.scada.configuration.arduino.ArduinoFactory;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.Device;
import org.eclipse.scada.configuration.infrastructure.lib.AbstractEquinoxDriverFactory;
import org.eclipse.scada.configuration.infrastructure.lib.DeviceTypeValidator;
import org.eclipse.scada.configuration.infrastructure.lib.DriverValidator;
import org.eclipse.scada.configuration.infrastructure.lib.Worlds;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.Node;

public class DriverFactoryImpl
extends AbstractEquinoxDriverFactory<ArduinoDriver> {
    public DriverFactoryImpl() {
        this.addValidator((DriverValidator)new DeviceTypeValidator(ArduinoDevice.class));
    }

    protected ArduinoDriver createDriver() {
        return ArduinoFactory.eINSTANCE.createArduinoDriver();
    }

    protected void configureDriver(AbstractFactoryDriver driver, ArduinoDriver result, Map<org.eclipse.scada.configuration.infrastructure.Node, Node> nodes) {
        for (Device device : driver.getDevices()) {
            if (!(device instanceof ArduinoDevice)) {
                throw new IllegalStateException(String.format("Device type %s is not supported", device.getClass()));
            }
            this.createDevice(result, (ArduinoDevice)device, nodes);
        }
    }

    protected void createDevice(ArduinoDriver driver, ArduinoDevice device, Map<org.eclipse.scada.configuration.infrastructure.Node, Node> nodes) {
        ArduinoConnection con = ArduinoFactory.eINSTANCE.createArduinoConnection();
        con.setName(device.getName());
        con.setShortDescription(device.getShortDescription());
        Endpoint ep = Worlds.createEndpoint((int)device.getPort(), (String)"Arduino Endpoint");
        con.setEndpoint(ep);
        Node node = nodes.get(device.getNode());
        if (node == null) {
            throw new IllegalStateException(String.format("Node %s was not found in target model", device.getNode()));
        }
        node.getEndpoints().add((Object)ep);
        driver.getArduinoConnections().add((Object)con);
    }
}

