/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator.calc;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.configuration.component.BufferedValue;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.generator.DataComponentGenerator;
import org.eclipse.scada.configuration.component.lib.Items;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.generator.FinishContext;
import org.eclipse.scada.configuration.generator.GenerationContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ItemReference;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.Persistence;

public class BufferedValueGenerator
extends DataComponentGenerator {
    private final BufferedValue bufferedValue;
    private final Map<MasterServer, org.eclipse.scada.configuration.world.osgi.BufferedValue> danglingBufferedValues = new HashMap<MasterServer, org.eclipse.scada.configuration.world.osgi.BufferedValue>();

    public BufferedValueGenerator(BufferedValue bufferedValue) {
        super((DataComponent)bufferedValue);
        this.bufferedValue = bufferedValue;
    }

    @Override
    protected void generateForMaster(GenerationContext context, GeneratorContext.MasterContext master) {
        org.eclipse.scada.configuration.world.osgi.BufferedValue bufferedValueGenerated = OsgiFactory.eINSTANCE.createBufferedValue();
        bufferedValueGenerated.setName(this.bufferedValue.getName());
        if (this.bufferedValue.getInput() != null) {
            ItemReference ref = OsgiFactory.eINSTANCE.createItemReference();
            ref.setName(this.bufferedValue.getInput().getName());
            ref.setItem((Item)this.bufferedValue.getInput().createReference());
            bufferedValueGenerated.setItem(ref);
            bufferedValueGenerated.setShortDescription(String.format("buffers item '%s' for %ss and is triggered every %ss", this.bufferedValue.getInput().getName(), this.bufferedValue.getRange() / 1000L, this.bufferedValue.getTrigger()));
        }
        if (this.bufferedValue.getInitialValue() != null) {
            bufferedValueGenerated.setInitialValue(this.bufferedValue.getInitialValue());
        }
        bufferedValueGenerated.setPersistence(Persistence.getByName((String)this.bufferedValue.getPersistence().getName()));
        bufferedValueGenerated.setRange(this.bufferedValue.getRange());
        bufferedValueGenerated.setTrigger(this.bufferedValue.getTrigger());
        bufferedValueGenerated.setTriggerOnly(Boolean.valueOf(this.bufferedValue.isTriggerOnly()));
        master.getImplementation().getBufferedValues().add((Object)bufferedValueGenerated);
        this.danglingBufferedValues.put(master.getImplementation(), bufferedValueGenerated);
        super.generateForMaster(context, master);
    }

    @Override
    public void createItems(ItemCreator itemCreator) {
    }

    @Override
    protected void finishForMaster(FinishContext context, GeneratorContext.MasterContext master) {
        org.eclipse.scada.configuration.world.osgi.BufferedValue bufferedValue = this.danglingBufferedValues.get(master.getImplementation());
        bufferedValue.getItem().setItem(Items.replaceDanglingReference((GeneratorContext)this.context, (MasterServer)master.getImplementation(), (Item)bufferedValue.getItem().getItem()));
    }
}

