/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.scada.configuration.generator.ui.AbstractFileRunner;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.configuration.infrastructure.lib.WorldGenerator;
import org.eclipse.scada.configuration.utils.ModelLoader;

public class RunInfrastructureGeneratorHandler
extends AbstractFileRunner {
    @Override
    protected void runFile(IFile file, IProgressMonitor monitor) throws Exception {
        RunInfrastructureGeneratorHandler.run(file, monitor);
    }

    public static void run(IFile file, IProgressMonitor monitor) throws CoreException, Exception {
        monitor.beginTask("Creating world", 11);
        monitor.setTaskName("Loading source model");
        World infra = (World)new ModelLoader(World.class).load(URI.createURI((String)file.getLocationURI().toString()));
        monitor.worked(1);
        monitor.setTaskName("Generating world");
        WorldGenerator gen = new WorldGenerator(infra);
        gen.generate((IProgressMonitor)new SubProgressMonitor(monitor, 7));
        monitor.setTaskName("Creating output files");
        RunInfrastructureGeneratorHandler.store(gen, file, monitor);
        monitor.worked(1);
        monitor.setTaskName("Refreshing");
        monitor.done();
    }

    private static void store(WorldGenerator gen, IFile sourceFile, IProgressMonitor monitor) throws Exception {
        IFile outputfile = sourceFile.getParent().getFile((IPath)new Path(String.valueOf(sourceFile.getName()) + ".eswm"));
        IFile globfile = sourceFile.getParent().getFile((IPath)new Path(String.valueOf(sourceFile.getName()) + ".globalize"));
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r1 = rs.createResource(URI.createURI((String)outputfile.getLocationURI().toString()), "org.eclipse.scada.configuration.world");
        Resource r2 = rs.createResource(URI.createURI((String)globfile.getLocationURI().toString()), "org.eclipse.scada.configuration.globalization");
        r1.getContents().add((Object)gen.getWorld());
        r2.getContents().add((Object)gen.getGlobalize());
        r1.save(null);
        r2.save(null);
        globfile.getParent().refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        outputfile.getParent().refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }
}

